/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import dev.latvian.mods.kubejs.bindings.event.BlockEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.block.BlockModificationKubeEvent;
import dev.latvian.mods.kubejs.item.ItemModificationKubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.TypeUtils;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public class UtilsJS {
    public static final RandomSource RANDOM = RandomSource.create();
    public static final ResourceLocation AIR_LOCATION = ResourceLocation.parse((String)"minecraft:air");
    public static final Pattern SNAKE_CASE_SPLIT = Pattern.compile("[:_/]");
    public static final Set<String> ALWAYS_LOWER_CASE = new HashSet<String>(Arrays.asList("a", "an", "the", "of", "on", "in", "and", "or", "but", "for"));
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Predicate<Object> ALWAYS_TRUE = o -> true;
    private static final Map<String, EntitySelector> ENTITY_SELECTOR_CACHE = new HashMap<String, EntitySelector>();
    private static final EntitySelector ALL_ENTITIES_SELECTOR = new EntitySelector(Integer.MAX_VALUE, true, false, List.of(), MinMaxBounds.Doubles.ANY, Function.identity(), null, EntitySelectorParser.ORDER_RANDOM, false, null, null, null, true);

    public static void tryIO(TryIO tryIO) {
        try {
            tryIO.run();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void queueIO(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    public static Object wrap(@Nullable Object o, JSObjectType type) {
        if (o == null || o instanceof WrappedJS || o instanceof Number || o instanceof Character || o instanceof String || o instanceof Enum || o.getClass().isPrimitive() && !o.getClass().isArray()) {
            return o;
        }
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return o.toString();
        }
        if (o instanceof EndTag || o instanceof JsonNull) {
            return null;
        }
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            return UtilsJS.wrap(w.unwrap(), type);
        }
        if (o instanceof NumericTag) {
            NumericTag tag = (NumericTag)o;
            return tag.getAsNumber();
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            return tag.getAsString();
        }
        if (o instanceof Tag) {
            return o;
        }
        if (o instanceof Map) {
            return o;
        }
        if (o instanceof Iterable) {
            Iterable itr = (Iterable)o;
            if (!type.checkList()) {
                return null;
            }
            ArrayList list = new ArrayList();
            for (Object o1 : itr) {
                list.add(o1);
            }
            return list;
        }
        if (o.getClass().isArray()) {
            if (type.checkList()) {
                return ListJS.ofArray(o);
            }
            return null;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)o;
            return JsonIO.toPrimitive((JsonElement)json);
        }
        if (o instanceof JsonObject) {
            JsonObject json = (JsonObject)o;
            if (!type.checkMap()) {
                return null;
            }
            HashMap map = new HashMap(json.size());
            for (Map.Entry entry : json.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        return o;
    }

    public static int parseInt(@Nullable Object object, int def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.intValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseLong(@Nullable Object object, long def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.longValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(@Nullable Object object, double def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.doubleValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Double.parseDouble(String.valueOf(object));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static <T> Predicate<T> onMatchDo(Predicate<T> predicate, Consumer<T> onMatch) {
        return t -> {
            boolean match = predicate.test(t);
            if (match) {
                onMatch.accept(t);
            }
            return match;
        };
    }

    public static void postModificationEvents() {
        BlockEvents.MODIFICATION.post(ScriptType.STARTUP, new BlockModificationKubeEvent());
        ItemEvents.MODIFICATION.post(ScriptType.STARTUP, new ItemModificationKubeEvent());
    }

    public static String toMappedTypeString(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            String mapped = clz.getName();
            int ld = mapped.lastIndexOf(46);
            return ld == -1 ? mapped : mapped.substring(ld + 1);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            Type owner = paramType.getOwnerType();
            if (owner != null) {
                sb.append(UtilsJS.toMappedTypeString(owner));
                sb.append('.');
            }
            sb.append(UtilsJS.toMappedTypeString(TypeUtils.getRawType((Type)paramType)));
            Type[] args = paramType.getActualTypeArguments();
            if (args.length > 0) {
                sb.append('<');
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(args[i]));
                }
                sb.append('>');
            }
            return sb.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrType = (GenericArrayType)type;
            return UtilsJS.toMappedTypeString(arrType.getGenericComponentType()) + "[]";
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            StringBuilder sb = new StringBuilder(typeVar.getName());
            Type[] bounds = typeVar.getBounds();
            if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) {
                sb.append(" extends ");
                for (int i = 0; i < bounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(bounds[i]));
                }
            }
            return sb.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            StringBuilder sb = new StringBuilder().append("?");
            Type[] lowerBounds = wildcard.getLowerBounds();
            Type[] upperBounds = wildcard.getUpperBounds();
            if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
                sb.append(" super ");
                for (int i = 0; i < lowerBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(lowerBounds[i]));
                }
            } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
                sb.append(" extends ");
                for (int i = 0; i < upperBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(upperBounds[i]));
                }
            }
            return sb.toString();
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, GenericArrayType, TypeVariable or WildcardType, but <" + String.valueOf(type) + "> is of type " + className);
    }

    public static String snakeCaseToCamelCase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String[] s = SNAKE_CASE_SPLIT.split(string, 0);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : s) {
            if (value.isEmpty()) continue;
            if (first) {
                first = false;
                sb.append(value);
                continue;
            }
            sb.append(Character.toUpperCase(value.charAt(0)));
            sb.append(value, 1, value.length());
        }
        return sb.toString();
    }

    public static String snakeCaseToTitleCase(String string) {
        StringJoiner joiner = new StringJoiner(" ");
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            String titleCase = UtilsJS.toTitleCase(s, i == 0);
            joiner.add(titleCase);
        }
        return joiner.toString();
    }

    public static String toTitleCase(String s) {
        return UtilsJS.toTitleCase(s, false);
    }

    public static String toTitleCase(String s, boolean ignoreSpecial) {
        if (s.isEmpty()) {
            return "";
        }
        if (!ignoreSpecial && ALWAYS_LOWER_CASE.contains(s)) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String stripIdForEvent(ResourceLocation id) {
        return UtilsJS.stripEventName(id.toString());
    }

    public static String getUniqueId(JsonElement json) {
        return UtilsJS.getUniqueId(json, Function.identity());
    }

    public static <T> String getUniqueId(T input, Function<T, JsonElement> toJson) {
        return JsonIO.getJsonHashString(toJson.apply(input));
    }

    public static String stripEventName(String s) {
        return s.replaceAll("[/:]", ".").replace('-', '_');
    }

    public static EntitySelector entitySelector(@Nullable Object o) {
        if (o == null) {
            return ALL_ENTITIES_SELECTOR;
        }
        if (o instanceof EntitySelector) {
            EntitySelector s = (EntitySelector)o;
            return s;
        }
        String s = o.toString();
        if (s.isBlank()) {
            return ALL_ENTITIES_SELECTOR;
        }
        EntitySelector sel = ENTITY_SELECTOR_CACHE.get(s);
        if (sel == null) {
            sel = ALL_ENTITIES_SELECTOR;
            try {
                sel = new EntitySelectorParser(new StringReader(s), true).parse();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ENTITY_SELECTOR_CACHE.put(s, sel);
        return sel;
    }

    @Nullable
    public static CreativeModeTab findCreativeTab(ResourceLocation id) {
        return (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(id);
    }

    public static <T> T makeFunctionProxy(Context cx, TypeInfo targetClass, BaseFunction function) {
        return Cast.to(cx.createInterfaceAdapter(targetClass, (ScriptableObject)function));
    }

    @FunctionalInterface
    public static interface TryIO {
        public void run() throws IOException;
    }
}

