/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.CuriosConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.CuriosSaveUtils;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class InGameConfigScreen
extends Screen {
    private final ResourceLocation INV_BG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/conf_bg.png");
    private final Component empty = Component.empty();
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private final int menu;
    private final boolean inGame;
    List<ConfigWidget> listForRender;

    public InGameConfigScreen(int menu, boolean inGame) {
        super((Component)Component.literal((String)"InventoryHUD Config Screen"));
        this.inGame = inGame;
        this.menu = menu;
    }

    protected void init() {
        int textPos;
        int ySize;
        int xSize;
        int pw;
        float potScale;
        this.listForRender = new ArrayList<ConfigWidget>();
        float invScale = (Boolean)InventoryHUD.getClientConfig().invMini.get() != false ? 0.75f : 1.0f;
        int invWidth = (Boolean)InventoryHUD.getClientConfig().invVert.get() != false ? 52 : 160;
        int invHeight = (Boolean)InventoryHUD.getClientConfig().invVert.get() != false ? 160 : 52;
        int x = this.getPosX((int)((float)invWidth * invScale), (Integer)InventoryHUD.getClientConfig().xPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHalign.get()));
        int y = this.getPosY((int)((float)invHeight * invScale), (Integer)InventoryHUD.getClientConfig().yPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invValign.get()));
        this.ICW = new ConfigWidget(x, y, invWidth, invHeight, invScale, Translation.INVGUI.getString(), InventoryHUD.isActive);
        this.listForRender.add(this.ICW);
        if (!((Boolean)InventoryHUD.getClientConfig().invVert.get()).booleanValue()) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(w -> this.onInvChanged());
        this.ICW.addPosListener(w -> this.onInvPosChanged());
        float f = ((Boolean)InventoryHUD.getClientConfig().potMini.get()).booleanValue() ? (((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue() ? 1.0f : 0.75f) : (potScale = 1.0f);
        int n = ((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClientConfig().potMini.get()).booleanValue() ? 18 : 36) : (pw = 60);
        int ph = ((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClientConfig().potMini.get()).booleanValue() ? 22 : 38) : 24;
        x = this.getPosX((int)((float)pw * potScale), (Integer)InventoryHUD.getClientConfig().xPotionPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().potHalign.get()));
        y = this.getPosY((int)((float)ph * potScale), (Integer)InventoryHUD.getClientConfig().yPotionPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().potValign.get()));
        this.PCW = new ConfigWidget(x, y, pw, ph, potScale, Translation.POTGUI.getString(), InventoryHUD.potionHUD);
        this.listForRender.add(this.PCW);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(w -> this.onPotionChanged());
        this.PCW.addPosListener(w -> this.onPotionPosChanged());
        float armScale = (float)((Integer)InventoryHUD.getClientConfig().armScale.get()).intValue() / 100.0f;
        if (((Boolean)InventoryHUD.getClientConfig().moveAll.get()).booleanValue()) {
            x = this.getPosX((int)(90.0f * armScale), (Integer)InventoryHUD.getClientConfig().xArmPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()));
            y = this.getPosY((int)(70.0f * armScale), (Integer)InventoryHUD.getClientConfig().yArmPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
            this.ACW = new ConfigWidget(x, y, 90, 70, armScale, Translation.ARMGUI.getString(), InventoryHUD.armorHUD);
            this.listForRender.add(this.ACW);
            this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
            this.ACW.addListener(w -> this.onArmorChanged());
            this.ACW.addPosListener(w -> this.onArmorPosChanged());
        } else {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().helmPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().helmHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().helmPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().helmVal.get()));
            ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_helmet.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 0));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().chestPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().chestHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().chestPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().chestVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_chestplate.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 1));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().legPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().legHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().legPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().legVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_leggings.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 2));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().bootPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().bootHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().bootPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().bootVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_boots.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 3));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().mainPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().mainHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().mainPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().mainVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showMain.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_main_hand_slot.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 5));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().offPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().offHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().offPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().offVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showOff.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_shield.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 4));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().arrPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().arrHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().arrPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().arrVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showArrows.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_arrows.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 7));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().invPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().invPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, this.empty.getString(), (Boolean)InventoryHUD.getClientConfig().showInv.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_inventory.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 6));
        }
        if (InventoryHUD.isCuriosMod && this.inGame && InventoryHUD.getInstance().getInventoryGui().hasCuriosSlots()) {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            for (Map.Entry<String, CuriosSlot> entry : InventoryHUD.getInstance().getInventoryGui().getCuriosSlots().entrySet()) {
                if (!entry.getValue().enabled) continue;
                x = this.getPosX(xSize, entry.getValue().x, entry.getValue().aligns.HorAlign);
                y = this.getPosY(ySize, entry.getValue().y, entry.getValue().aligns.VertAlign);
                ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, Component.literal((String)"").getString(), entry.getValue().enabled, false);
                this.listForRender.add(tmp);
                tmp.initTextureValues(textPos, 124, new Color4F(1.0f, 0.5f, 0.0f, 1.0f), this.INV_BG, entry.getValue().icon);
                tmp.addPosListener(w -> this.onCuriosItemPosChanged(w, (CuriosSlot)entry.getValue()));
            }
        }
        this.listForRender.forEach(x$0 -> {
            ConfigWidget cfr_ignored_0 = (ConfigWidget)this.addWidget((GuiEventListener)x$0);
        });
    }

    public boolean mouseReleased(double x, double y, int b) {
        this.listForRender.forEach(w -> w.onRelease(x, y));
        return super.mouseReleased(x, y, b);
    }

    private int getPosX(int width, int posX, WidgetAligns.HAlign hal) {
        int result = switch (hal) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> posX;
            case WidgetAligns.HAlign.RIGHT -> this.width - posX;
            case WidgetAligns.HAlign.MIDDLE -> this.width / 2 - width / 2 - posX;
        };
        return Mth.clamp((int)result, (int)0, (int)(this.width - width));
    }

    private int getPosY(int height, int posY, WidgetAligns.VAlign hal) {
        int result = switch (hal) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.VAlign.TOP -> posY;
            case WidgetAligns.VAlign.BOTTOM -> this.height - posY;
            case WidgetAligns.VAlign.CENTER -> this.height / 2 - height / 2 - posY;
        };
        return Mth.clamp((int)result, (int)0, (int)(this.height - height));
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gui, mouseX, mouseY, partialTick);
        RenderSystem.enableBlend();
        gui.blit(this.CONF_BG, 0, this.height / 3 - 1, (float)this.width, 3.0f, this.width, 3, 3, 3);
        gui.blit(this.CONF_BG, 0, this.height / 3 * 2 - 1, (float)this.width, 3.0f, this.width, 3, 3, 3);
        gui.blit(this.CONF_BG, this.width / 3 - 1, 0, 3.0f, (float)this.height, 3, this.height, 3, 3);
        gui.blit(this.CONF_BG, this.width / 3 * 2 - 1, 0, 3.0f, (float)this.height, 3, this.height, 3, 3);
        RenderSystem.disableBlend();
        this.listForRender.forEach(r -> r.render(gui, mouseX, mouseY, partialTick));
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InventoryHUD.getClientConfig().byDefault.set((Object)this.ICW.getShow());
        InventoryHUD.saveConfig();
    }

    private void onInvPosChanged() {
        Minecraft mc = Minecraft.getInstance();
        if (this.ICW.x + this.ICW.getWidth() / 2 <= mc.screen.width / 3) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.invX = this.ICW.x;
        } else if (this.ICW.x + this.ICW.getWidth() / 2 >= mc.screen.width / 3 * 2) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.invX = mc.screen.width - this.ICW.x;
        } else {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.invX = this.ICW.x + this.ICW.getWidth() / 2 <= mc.screen.width / 2 - 10 ? mc.screen.width / 2 - this.ICW.getWidth() / 2 - this.ICW.x : (this.ICW.x + this.ICW.getWidth() / 2 >= mc.screen.width / 2 + 10 ? mc.screen.width / 2 - this.ICW.getWidth() / 2 - this.ICW.x : 0);
        }
        if (this.ICW.y + this.ICW.getHeight() / 2 <= mc.screen.height / 3) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.invY = this.ICW.y;
        } else if (this.ICW.y + this.ICW.getHeight() / 2 >= mc.screen.height / 3 * 2) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.invY = mc.screen.height - this.ICW.y;
        } else {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.invY = this.ICW.y + this.ICW.getHeight() / 2 <= mc.screen.height / 2 - 10 ? mc.screen.height / 2 - this.ICW.getHeight() / 2 - this.ICW.y : (this.ICW.y + this.ICW.getHeight() / 2 >= mc.screen.height / 2 + 10 ? mc.screen.height / 2 - this.ICW.getHeight() / 2 - this.ICW.y : 0);
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InventoryHUD.getClientConfig().Potions.set((Object)this.PCW.getShow());
        InventoryHUD.saveConfig();
    }

    private void onPotionPosChanged() {
        Minecraft mc = Minecraft.getInstance();
        if (this.PCW.x + this.PCW.getWidth() / 2 <= mc.screen.width / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.PCW.x;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else if (this.PCW.x + this.PCW.getWidth() / 2 >= mc.screen.width / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.screen.width - this.PCW.x;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.x + this.PCW.getWidth() / 2 <= mc.screen.width / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.screen.width / 2 - this.PCW.getWidth() / 2 - this.PCW.x;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else if (this.PCW.x + this.PCW.getWidth() / 2 >= mc.screen.width / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.screen.width / 2 - this.PCW.getWidth() / 2 - this.PCW.x;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            }
        }
        if (this.PCW.y + this.PCW.getHeight() / 2 <= mc.screen.height / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.PCW.y;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
        } else if (this.PCW.y + this.PCW.getHeight() / 2 >= mc.screen.height / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.screen.height - this.PCW.y;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.y + this.PCW.getHeight() / 2 <= mc.screen.height / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.screen.height / 2 - this.PCW.getHeight() / 2 - this.PCW.y;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            } else if (this.PCW.y + this.PCW.getHeight() / 2 >= mc.screen.height / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.screen.height / 2 - this.PCW.getHeight() / 2 - this.PCW.y;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InventoryHUD.getClientConfig().ArmorDamage.set((Object)this.ACW.getShow());
        InventoryHUD.saveConfig();
    }

    private void onArmorPosChanged() {
        int ay;
        int ax;
        Minecraft mc = Minecraft.getInstance();
        WidgetAligns armal = new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.BOTTOM);
        if (this.ACW.x + this.ACW.getWidth() / 2 <= mc.screen.width / 3) {
            armal.HorAlign = WidgetAligns.HAlign.LEFT;
            ax = this.ACW.x;
        } else if (this.ACW.x + this.ACW.getWidth() / 2 >= mc.screen.width / 3 * 2) {
            armal.HorAlign = WidgetAligns.HAlign.RIGHT;
            ax = mc.screen.width - this.ACW.x;
        } else {
            armal.HorAlign = WidgetAligns.HAlign.MIDDLE;
            ax = this.ACW.x + this.ACW.getWidth() / 2 <= mc.screen.width / 2 - 10 ? mc.screen.width / 2 - this.ACW.getWidth() / 2 - this.ACW.x : (this.ACW.x + this.ACW.getWidth() / 2 >= mc.screen.width / 2 + 10 ? mc.screen.width / 2 - this.ACW.getWidth() / 2 - this.ACW.x : 0);
        }
        if (this.ACW.y + this.ACW.getHeight() / 2 <= mc.screen.height / 2 - 10) {
            armal.VertAlign = WidgetAligns.VAlign.TOP;
            ay = this.ACW.y;
        } else if (this.ACW.y + this.ACW.getHeight() / 2 >= mc.screen.height / 2 + 10) {
            armal.VertAlign = WidgetAligns.VAlign.BOTTOM;
            ay = mc.screen.height - this.ACW.y;
        } else {
            armal.VertAlign = WidgetAligns.VAlign.CENTER;
            ay = this.ACW.y + this.ACW.getHeight() / 2 <= mc.screen.height / 2 - 10 ? mc.screen.height / 2 - this.ACW.getHeight() / 2 - this.ACW.y : (this.ACW.y + this.ACW.getHeight() / 2 >= mc.screen.height / 2 + 10 ? mc.screen.height / 2 - this.ACW.getHeight() / 2 - this.ACW.y : 0);
        }
        InventoryHUD.getInstance().getInventoryGui().changeArmorPos(armal, ax, ay);
    }

    private void onCuriosItemPosChanged(ConfigWidget w, CuriosSlot slot) {
        if (w.x + w.getWidth() / 2 <= this.minecraft.screen.width / 3) {
            slot.aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            slot.x = w.x;
        } else if (w.x + w.getWidth() / 2 >= this.minecraft.screen.width / 3 * 2) {
            slot.aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            slot.x = this.minecraft.screen.width - w.x;
        } else {
            slot.aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            slot.x = this.minecraft.screen.width / 2 - w.getWidth() / 2 - w.x;
        }
        if (w.y + w.getHeight() / 2 <= this.minecraft.screen.height / 2 - 10) {
            slot.aligns.VertAlign = WidgetAligns.VAlign.TOP;
            slot.y = w.y;
        } else if (w.y + w.getHeight() / 2 >= this.minecraft.screen.height / 2 + 10) {
            slot.aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            slot.y = this.minecraft.screen.height - w.y;
        } else {
            slot.aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            slot.y = this.minecraft.screen.height / 2 - w.getHeight() / 2 - w.y;
        }
    }

    private void onItemPosChanged(ConfigWidget w, int i) {
        Minecraft mc = Minecraft.getInstance();
        if (w.x + w.getWidth() / 2 <= mc.screen.width / 3) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = w.x;
        } else if (w.x + w.getWidth() / 2 >= mc.screen.width / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.screen.width - w.x;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.screen.width / 2 - w.getWidth() / 2 - w.x;
        }
        if (w.y + w.getHeight() / 2 <= mc.screen.height / 2 - 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = w.y;
        } else if (w.y + w.getHeight() / 2 >= mc.screen.height / 2 + 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.screen.height - w.y;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.screen.height / 2 - w.getHeight() / 2 - w.y;
        }
    }

    private void saveConfig() {
        InventoryHUD.getClientConfig().xPos.set((Object)InventoryGui.invX);
        InventoryHUD.getClientConfig().yPos.set((Object)InventoryGui.invY);
        InventoryHUD.getClientConfig().invHalign.set((Object)InventoryGui.InvAligns.HorAlign);
        InventoryHUD.getClientConfig().invValign.set((Object)InventoryGui.InvAligns.VertAlign);
        InventoryHUD.getClientConfig().xPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX);
        InventoryHUD.getClientConfig().yPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY);
        InventoryHUD.getClientConfig().potHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign);
        InventoryHUD.getClientConfig().potValign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign);
        InventoryHUD.getClientConfig().xArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armX);
        InventoryHUD.getClientConfig().yArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armY);
        InventoryHUD.getClientConfig().armHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.HorAlign);
        InventoryHUD.getClientConfig().armValign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.VertAlign);
        InventoryHUD.getClientConfig().helmPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].x);
        InventoryHUD.getClientConfig().chestPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].x);
        InventoryHUD.getClientConfig().legPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].x);
        InventoryHUD.getClientConfig().bootPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].x);
        InventoryHUD.getClientConfig().offPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].x);
        InventoryHUD.getClientConfig().mainPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].x);
        InventoryHUD.getClientConfig().invPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].x);
        InventoryHUD.getClientConfig().arrPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].x);
        InventoryHUD.getClientConfig().helmPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].y);
        InventoryHUD.getClientConfig().chestPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].y);
        InventoryHUD.getClientConfig().legPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].y);
        InventoryHUD.getClientConfig().bootPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].y);
        InventoryHUD.getClientConfig().offPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].y);
        InventoryHUD.getClientConfig().mainPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].y);
        InventoryHUD.getClientConfig().invPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].y);
        InventoryHUD.getClientConfig().arrPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].y);
        InventoryHUD.getClientConfig().helmHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.HorAlign);
        InventoryHUD.getClientConfig().chestHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.HorAlign);
        InventoryHUD.getClientConfig().legHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.HorAlign);
        InventoryHUD.getClientConfig().bootHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.HorAlign);
        InventoryHUD.getClientConfig().offHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.HorAlign);
        InventoryHUD.getClientConfig().mainHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.HorAlign);
        InventoryHUD.getClientConfig().invHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.HorAlign);
        InventoryHUD.getClientConfig().arrHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.HorAlign);
        InventoryHUD.getClientConfig().helmVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.VertAlign);
        InventoryHUD.getClientConfig().chestVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.VertAlign);
        InventoryHUD.getClientConfig().legVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.VertAlign);
        InventoryHUD.getClientConfig().bootVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.VertAlign);
        InventoryHUD.getClientConfig().offVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.VertAlign);
        InventoryHUD.getClientConfig().mainVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.VertAlign);
        InventoryHUD.getClientConfig().invVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.VertAlign);
        InventoryHUD.getClientConfig().arrVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.VertAlign);
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            CuriosSaveUtils.save();
        }
    }

    public void onClose() {
        this.saveConfig();
        switch (this.menu) {
            case -1: {
                this.minecraft.setScreen(null);
                break;
            }
            case 0: {
                this.minecraft.setScreen((Screen)new InventoryConfigScreen(this.inGame));
                break;
            }
            case 1: {
                this.minecraft.setScreen((Screen)new ArmorConfigScreen(this.inGame));
                break;
            }
            case 2: {
                this.minecraft.setScreen((Screen)new PotionConfigScreen(this.inGame));
                break;
            }
            case 3: {
                this.minecraft.setScreen((Screen)new CuriosConfigScreen(this.inGame));
            }
        }
    }
}

