/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InGameConfigScreen;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.CuriosConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.config.ScreenWithOptionList;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CheckBox;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.CustomOptionList;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.ModListScreen;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends ScreenWithOptionList {
    protected CustomButton InventoryBtn;
    protected CustomButton ArmorBtn;
    protected CustomButton PotionBtn;
    protected CustomButton PositionBtn;
    private final boolean[] pressedButtons = new boolean[]{false, false, false, false};
    private final int menu;
    protected boolean inGame;
    protected List<Widget> widgetList = new ArrayList<Widget>();

    public ConfigScreen(int menu, boolean inGame) {
        super((Component)Component.literal((String)"Inventory HUD+ Config"));
        this.inGame = inGame;
        this.menu = menu;
        this.pressedButtons[menu] = true;
    }

    protected void init() {
        this.optionList = new CustomOptionList(this.minecraft, this);
        this.widgetList = new ArrayList<Widget>();
        int xOffset = 0;
        if (InventoryHUD.isCuriosMod && this.inGame && InventoryHUD.getInstance().getInventoryGui().hasCuriosSlots()) {
            xOffset = -24;
            CustomButton tmp = new CustomButton(this.width / 2 + 30, 8, 36, 36, "CuriosAPI", ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/curios_icon.png"), this.pressedButtons[3], (w, g, x, y) -> g.renderTooltip(this.font, (Component)Component.translatable((String)"CuriosAPI"), x, y));
            this.widgetList.add(tmp);
            tmp.addListener(btn -> this.minecraft.setScreen((Screen)new CuriosConfigScreen(this.inGame)));
        }
        this.InventoryBtn = new CustomButton(this.width / 2 - 90 + xOffset, 8, 36, 36, "InvHUD", ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/inv_btn.png"), this.pressedButtons[0], (w, g, x, y) -> g.renderTooltip(this.font, Translation.INV_TT, x, y));
        this.widgetList.add(this.InventoryBtn);
        this.InventoryBtn.addListener(btn -> Minecraft.getInstance().setScreen((Screen)new InventoryConfigScreen(this.inGame)));
        this.ArmorBtn = new CustomButton(this.width / 2 - 42 + xOffset, 8, 36, 36, "ArmHUD", ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/arm_btn.png"), this.pressedButtons[1], (w, g, x, y) -> g.renderTooltip(this.font, Translation.ARM_TT, x, y));
        this.widgetList.add(this.ArmorBtn);
        this.ArmorBtn.addListener(btn -> Minecraft.getInstance().setScreen((Screen)new ArmorConfigScreen(this.inGame)));
        this.PotionBtn = new CustomButton(this.width / 2 + 6 + xOffset, 8, 36, 36, "PotHUD", ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/pot_btn.png"), this.pressedButtons[2], (w, g, x, y) -> g.renderTooltip(this.font, Translation.POT_TT, x, y));
        this.widgetList.add(this.PotionBtn);
        this.PotionBtn.addListener(btn -> Minecraft.getInstance().setScreen((Screen)new PotionConfigScreen(this.inGame)));
        this.PositionBtn = new CustomButton(this.width / 2 + 54 - xOffset, 8, 36, 36, "InvHUD", ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/pos_btn.png"), false, (w, g, x, y) -> g.renderTooltip(this.font, Translation.POS_TT, x, y));
        this.widgetList.add(this.PositionBtn);
        this.PositionBtn.addListener(btn -> Minecraft.getInstance().setScreen((Screen)new InGameConfigScreen(this.menu, this.inGame)));
        this.addRenderableWidget((GuiEventListener)this.optionList);
        this.widgetList.forEach(x$0 -> {
            Widget cfr_ignored_0 = (Widget)this.addWidget((GuiEventListener)x$0);
        });
    }

    protected void addButton(int index, String text, ButtonWidget.ButtonClickListener onClick) {
        this.addButton(index, 40, text, onClick);
    }

    protected void addButton(int index, int width, String text, ButtonWidget.ButtonClickListener onClick) {
        CustomButton newButton = new CustomButton(this.width / 2 + 20, 0, width, 20, text);
        this.optionList.addWidget(newButton, index);
        newButton.addListener(onClick);
    }

    protected void addNumericField(int index, int minValue, int maxValue, int defValue, TextField.IPressable onChange, int maxLength) {
        NumericTextField field = this.addNumericField(index, minValue, maxValue, defValue, onChange);
        field.setMaxStringLength(maxLength);
    }

    protected NumericTextField addNumericField(int index, int minValue, int maxValue, int defValue, TextField.IPressable onChange) {
        NumericTextField result = new NumericTextField(this.font, this.width / 2 + 20, 0, 40, 20, minValue, maxValue, defValue, onChange);
        this.optionList.addWidget(result, index);
        return result;
    }

    protected void addCheckbox(int index, boolean toggle, CheckBox.IPressable onChange, ResourceLocation icon) {
        this.addCheckbox(index, 0, toggle, onChange, icon);
    }

    protected void addCheckbox(int index, int xOffset, boolean toggle, CheckBox.IPressable onChange, ResourceLocation icon) {
        this.optionList.addWidget(new CheckBox(this.width / 2 + 20 + xOffset, 0, 20, 20, onChange, toggle, icon), index);
    }

    protected void addText(int index, String text) {
        this.optionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, text, this.font), index);
    }

    protected void addText(int index, String text, Component tooltip) {
        this.optionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, text, this.font, (w, g, x, y) -> g.renderTooltip(this.font, tooltip, x, y)), index);
    }

    protected void addText(int index, String text, List<Component> tooltip) {
        this.optionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, text, this.font, (w, g, x, y) -> g.renderComponentTooltip(this.font, tooltip, x, y)), index);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gui, mouseX, mouseY, partialTick);
        this.optionList.render(gui, mouseX, mouseY, partialTick);
        for (Widget widget : this.widgetList) {
            widget.render(gui, mouseX, mouseY, partialTick);
        }
        this.optionList.renderTooltips(gui, mouseX, mouseY);
        for (Widget widget : this.widgetList) {
            widget.renderTooltip(gui, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double m1, double m2, int m3) {
        boolean result = super.mouseClicked(m1, m2, m3);
        if (result) {
            for (Widget w : this.widgetList) {
                if (!(w instanceof NumericTextField)) continue;
                w.mouseClicked(m1, m2, m3);
            }
        }
        return result;
    }

    public void onClose() {
        if (!this.inGame) {
            this.minecraft.setScreen((Screen)new ModListScreen(null));
        } else {
            this.minecraft.setScreen(null);
        }
    }
}

