/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.StringUtils;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class PotionRenderer
extends HudRenderer {
    private final ResourceLocation POTION_DIGITS = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/potion_digits.png");
    protected final int BG_WIDTH;
    protected final int BG_HEIGHT;
    protected final int ICON_SIZE;
    public boolean potMini;
    public boolean showHidden;
    public boolean potionLevels;
    public boolean withDebug;
    public int potX;
    public int potY;
    public int potSide;
    public int potIconSide;
    public int potTextSide;
    public int potVert;
    public int barDuration;
    public int potGap;
    public float potAlpha;
    public WidgetAligns PotAligns;
    public Set<String> blackList;
    Minecraft mc;
    final ResourceLocation PMT = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/potminitime.png");

    public PotionRenderer(Minecraft mc, int bgWidth, int bgHeight, int iconSize) {
        this.mc = mc;
        this.BG_WIDTH = bgWidth;
        this.BG_HEIGHT = bgHeight;
        this.ICON_SIZE = iconSize;
    }

    public void render(GuiGraphics gui, int width, int height) {
    }

    protected void preDraw(GuiGraphics gui) {
        gui.pose().pushPose();
        gui.pose().translate(0.0, 0.0, -255.0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
    }

    protected List<MobEffectInstance> filteredEffects() {
        return this.mc.player.getActiveEffects().stream().filter(e -> (e.showIcon() || this.showHidden) && !this.getBlacklist().contains(((MobEffect)e.getEffect().value()).getDescriptionId())).toList();
    }

    void setBarColorByScale(float scale) {
        float r = 1.0f;
        float g = 1.0f;
        if (scale < 0.5f) {
            g = scale / 0.5f;
        } else {
            r = 1.0f - (scale - 0.5f) / 0.5f;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)0.0f, (float)1.0f);
    }

    float getBarScale(MobEffectInstance effect) {
        int dur = effect.getDuration();
        return effect.isInfiniteDuration() ? 1.0f : Math.min((float)dur / (float)this.barDuration, 1.0f);
    }

    int getBarSize(float scale) {
        return Math.max(1, (int)(scale * 12.0f));
    }

    void drawBackground(GuiGraphics gui, ResourceLocation bgResource, int x, int y, int bgXScale, int bgYScale) {
        gui.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
        RenderSystem.enableBlend();
        gui.blit(bgResource, x, y, (float)this.BG_WIDTH, (float)this.BG_HEIGHT, this.BG_WIDTH, this.BG_HEIGHT, this.BG_WIDTH * bgXScale, this.BG_HEIGHT * bgYScale);
        RenderSystem.disableBlend();
        gui.pose().popPose();
    }

    void drawIcon(GuiGraphics gui, Holder<MobEffect> effect, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureAtlasSprite textureatlassprite = this.mc.getMobEffectTextures().get(effect);
        gui.blit(x, y, 0, this.ICON_SIZE, this.ICON_SIZE, textureatlassprite);
    }

    void drawLevel(GuiGraphics gui, int x, int y, int level) {
        boolean sign;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.POTION_DIGITS);
        int xOffset = -2;
        int yOffset = 1;
        if (!(++level >= 1 && level <= 9 || this.potionLevels)) {
            gui.blit(this.POTION_DIGITS, x - xOffset - 1, y + yOffset, 7, 7, 50.0f, 0.0f, 7, 7, 64, 7);
            return;
        }
        boolean bl = sign = level < 0;
        while (level > 0) {
            int digit = level % 10;
            int texX = digit * 5;
            gui.blit(this.POTION_DIGITS, x - xOffset, y + yOffset, 5, 7, (float)texX, 0.0f, 5, 7, 64, 7);
            xOffset += 4;
            level /= 10;
        }
        if (sign) {
            gui.blit(this.POTION_DIGITS, x - xOffset, y + yOffset, 4, 7, 57.0f, 0.0f, 4, 7, 64, 7);
        }
    }

    void drawDurationBar(GuiGraphics gui, MobEffectInstance effect, int x, int y, int width, int height) {
        this.setBarColorByScale(this.getBarScale(effect));
        gui.blit(this.PMT, x, y, (float)width, (float)height, width, height, width, height);
    }

    void drawDuration(GuiGraphics gui, MobEffectInstance effect, int x, int y) {
        String time = " **:**";
        int dur = effect.getDuration() / 20;
        if (!effect.isInfiniteDuration() && dur < 1600) {
            int minutes = dur / 60;
            int seconds = dur % 60;
            time = dur > 10 ? String.format("%02d:%02d", minutes, seconds) : String.format("%s%02d%s:%s%02d", ChatFormatting.RED, minutes, ChatFormatting.WHITE, ChatFormatting.RED, seconds);
        }
        gui.drawString(this.mc.font, time, x, y, 0xFFFFFF);
    }

    void postDraw(GuiGraphics gui) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        gui.pose().popPose();
    }

    private void PotPosVertChanged() {
        switch (this.PotAligns.HorAlign) {
            case RIGHT: {
                if (!this.potMini) {
                    this.potSide = -1;
                    this.potIconSide = 36;
                    this.potTextSide = -22;
                    break;
                }
                this.potSide = -1;
                this.potIconSide = 4;
                this.potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    if (!this.potMini) {
                        this.potSide = -1;
                        this.potIconSide = 36;
                        this.potTextSide = -22;
                        break;
                    }
                    this.potSide = -1;
                    this.potIconSide = 4;
                    this.potTextSide = -15;
                    break;
                }
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
                break;
            }
            case LEFT: {
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
            }
        }
    }

    public void PotPosChanged() {
        if (((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue()) {
            this.PotPosHorChanged();
        } else {
            this.PotPosVertChanged();
        }
    }

    private void PotPosHorChanged() {
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    this.potSide = -1;
                    this.potTextSide = 2;
                    this.potIconSide = 4;
                    break;
                }
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case BOTTOM: {
                this.potSide = -1;
                this.potTextSide = 2;
                this.potIconSide = 4;
            }
        }
    }

    public void PotPosYChanged(boolean top) {
        this.potVert = top ? 1 : -1;
    }

    public Set<String> getBlacklist() {
        if (this.blackList == null) {
            this.resetBlacklist();
        }
        return this.blackList;
    }

    public void resetBlacklist() {
        this.blackList = StringUtils.effectDescIdsSet((List)InventoryHUD.getClientConfig().effectsBlacklist.get());
    }
}

