/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.logging.PacketLogging;
import java.nio.channels.ClosedChannelException;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Connection.class}, priority=5)
public abstract class AdvancedPacketErrorLogging {
    @Shadow
    protected abstract void sendPacket(Packet<?> var1, @Nullable PacketSendListener var2, boolean var3);

    @Redirect(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;sendPacket(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"), require=0)
    private void connectivity$logErrorFor(Connection instance, Packet<?> packet, PacketSendListener listener, boolean bool) {
        this.connectivity$wrapSend(packet, listener, bool);
    }

    @Unique
    private void connectivity$wrapSend(Packet<?> packet, PacketSendListener listener, boolean bool) {
        try {
            this.sendPacket(packet, listener, bool);
        }
        catch (Throwable t) {
            if (!(t instanceof ClosedChannelException)) {
                PacketLogging.logPacket(packet, "threw an error:" + t.getLocalizedMessage());
            }
            throw t;
        }
    }
}

