/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.base.Charsets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.custom.DiscardedQueryPayload;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientboundCustomQueryPacket.class})
public class ClientboundCustomQueryPacketMixin {
    @Inject(method={"readUnknownPayload"}, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")}, cancellable=true)
    private static void onLargePacket(ResourceLocation resourceLocation, FriendlyByteBuf data, CallbackInfoReturnable<DiscardedQueryPayload> cir) {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            data.resetReaderIndex();
            Connectivity.LOGGER.warn("Too big ClientboundCustomQueryPacket payload data!");
            Connectivity.LOGGER.warn("Data:" + data.toString(Charsets.UTF_8));
            data.resetReaderIndex();
        }
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).disableLoginLimits) {
            cir.setReturnValue((Object)new DiscardedQueryPayload(resourceLocation));
        }
    }
}

