/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.VarInt;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CompressionDecoder.class}, priority=99)
public abstract class NettyCompressionDecoderMixin
extends ByteToMessageDecoder {
    @Shadow
    private int threshold;
    @Shadow
    @Final
    private Inflater inflater;
    @Shadow
    private boolean validateDecompressed;

    @Shadow
    protected abstract void setupInflaterInput(ByteBuf var1);

    @Shadow
    protected abstract ByteBuf inflate(ChannelHandlerContext var1, int var2) throws DataFormatException;

    @Overwrite
    public void decode(ChannelHandlerContext context, ByteBuf byteBuf, List<Object> decoded) throws Exception {
        if (byteBuf.readableBytes() != 0) {
            int i = VarInt.read((ByteBuf)byteBuf);
            if (i == 0) {
                decoded.add(byteBuf.readBytes(byteBuf.readableBytes()));
            } else {
                this.setupInflaterInput(byteBuf);
                ByteBuf byteBuf2 = this.inflate(context, i);
                this.inflater.reset();
                decoded.add(byteBuf2);
                if (this.validateDecompressed) {
                    if (i < this.threshold) {
                        this.printDebug(decoded);
                        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
                            throw new DecoderException("Badly compressed packet - size of " + i + " is below server threshold of " + this.threshold);
                        }
                    }
                    if (i > 0x800000) {
                        this.printDebug(decoded);
                        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
                            throw new DecoderException("Badly compressed packet - size of " + i + " is larger than protocol maximum of 8388608");
                        }
                    }
                }
            }
        }
    }

    private void printDebug(List<Object> decodingResults) {
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            return;
        }
        Connectivity.LOGGER.error("Received too large message, debug print below!");
        Connectivity.LOGGER.error("----BEGIND PRINTING PACKET-----");
        for (int i = 0; i < decodingResults.size(); ++i) {
            ByteBuf buf = (ByteBuf)decodingResults.get(i);
            if (buf == null) continue;
            Connectivity.LOGGER.error("Data:");
            Connectivity.LOGGER.error(buf.toString(Charsets.UTF_8));
        }
        Connectivity.LOGGER.error("----END PRINTING PACKET-----");
    }
}

