/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.channels.ClosedChannelException;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class NetworkManagerMixin {
    @Shadow
    private Channel channel;
    @Unique
    private int counter = 0;

    @Shadow
    public abstract void disconnect(Component var1);

    @Inject(method={"exceptionCaught"}, at={@At(value="HEAD")})
    public void on(ChannelHandlerContext packet, Throwable component, CallbackInfo ci) {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages && !(component instanceof ClosedChannelException)) {
            Connectivity.LOGGER.warn("Network error for:" + packet.name(), component);
        }
        if (!this.channel.isOpen()) {
            ++this.counter;
            if (this.counter >= 10 && this.counter == 10) {
                this.disconnect((Component)Component.literal((String)"Forced closure due to network errors"));
                ServerLifecycleHooks.getCurrentServer().submit(() -> ServerLifecycleHooks.getCurrentServer().getConnection().getConnections().remove((Connection)this));
                packet.close();
            }
        }
    }
}

