/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesBiomeModifier;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesFeature;
import bl4ckscor3.mod.snowundertrees.manager.SnowManager;
import bl4ckscor3.mod.snowundertrees.manager.SnowRealMagicManager;
import bl4ckscor3.mod.snowundertrees.manager.VanillaManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="snowundertrees")
public class SnowUnderTrees {
    public static final String MODID = "snowundertrees";
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"snowundertrees");
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"snowundertrees");
    public static final DeferredHolder<Feature<?>, SnowUnderTreesFeature> SNOW_UNDER_TREES_FEATURE = FEATURES.register("snow_under_trees", () -> new SnowUnderTreesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<SnowUnderTreesBiomeModifier>> SNOW_UNDER_TREES_BIOME_MODIFIER_CODEC = BIOME_MODIFIER_SERIALIZERS.register("snow_under_trees", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)PlacedFeature.CODEC.fieldOf("feature").forGetter(SnowUnderTreesBiomeModifier::snowUnderTreesFeature)).apply((Applicative)builder, SnowUnderTreesBiomeModifier::new)));
    public static final RandomSource RANDOM = RandomSource.create();
    public static List<ResourceLocation> biomesToAddTo = new ArrayList<ResourceLocation>();
    public static SnowManager snowManager;
    private static boolean isSereneSeasonsLoaded;
    private static boolean isEternalWinterLoaded;
    private static BiFunction<WorldGenLevel, BlockPos, Boolean> temperatureCheck;

    public SnowUnderTrees(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
        FEATURES.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        isSereneSeasonsLoaded = ModList.get().isLoaded("sereneseasons");
        isEternalWinterLoaded = ModList.get().isLoaded("eternalwinter");
        snowManager = ModList.get().isLoaded("snowrealmagic") ? new SnowRealMagicManager() : new VanillaManager();
        temperatureCheck = isSereneSeasonsLoaded ? (level, pos) -> SereneSeasonsHandler.coldEnoughToSnow(level, (Holder<Biome>)level.getBiome(pos), pos) : (level, pos) -> !((Biome)level.getBiome(pos).value()).warmEnoughToRain(pos);
    }

    public static void addSnowUnderTrees(ResourceLocation biomeName) {
        if (!biomesToAddTo.contains(biomeName)) {
            biomesToAddTo.add(biomeName);
        }
    }

    public static boolean placeSnow(WorldGenLevel level, BlockPos pos) {
        return snowManager.placeSnow(level, pos);
    }

    public static boolean canSnow(WorldGenLevel level, BlockPos pos) {
        Holder biome = level.getBiome(pos);
        if (((Biome)biome.value()).getPrecipitationAt(pos) == Biome.Precipitation.SNOW || isSereneSeasonsLoaded && SereneSeasonsHandler.coldEnoughToSnow(level, (Holder<Biome>)biome, pos)) {
            BlockState stateAtPos = level.getBlockState(pos);
            if (!stateAtPos.canBeReplaced()) {
                return false;
            }
            if (temperatureCheck.apply(level, pos).booleanValue() && SnowUnderTrees.isInBuildRangeAndDarkEnough(level, pos)) {
                BlockPos posBelow = pos.below();
                BlockState stateBelow = level.getBlockState(posBelow);
                return stateBelow.isFaceSturdy((BlockGetter)level, posBelow, Direction.UP);
            }
        }
        return false;
    }

    public static boolean isSnow(WorldGenLevel level, BlockPos pos) {
        return snowManager.isSnow(level, pos);
    }

    public static BlockState getStateAfterMelting(BlockState stateNow, WorldGenLevel level, BlockPos pos) {
        return snowManager.getStateAfterMelting(stateNow, level, pos);
    }

    private static final boolean isInBuildRangeAndDarkEnough(WorldGenLevel level, BlockPos pos) {
        return pos.getY() >= level.getMinBuildHeight() && pos.getY() < level.getMaxBuildHeight() && level.getBrightness(LightLayer.BLOCK, pos) < 10;
    }

    public static boolean isSereneSeasonsLoaded() {
        return isSereneSeasonsLoaded;
    }

    public static boolean isEternalWinterLoaded() {
        return isEternalWinterLoaded;
    }
}

