/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles.base;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseThrownPearl
extends ThrowableItemProjectile {
    public BaseThrownPearl(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public BaseThrownPearl(EntityType<? extends ThrowableItemProjectile> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    public void tick() {
        ServerPlayer player;
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isAlive() && this.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else {
            super.tick();
        }
    }

    public boolean canChangeDimensions(Level level, Level destinationLevel) {
        boolean bl;
        Entity entity;
        if (level.dimension() == Level.END && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            bl = super.canChangeDimensions(level, destinationLevel) && serverplayer.seenCredits;
        } else {
            bl = super.canChangeDimensions(level, destinationLevel);
        }
        return bl;
    }

    protected void onInsideBlock(BlockState state) {
        Entity entity;
        super.onInsideBlock(state);
        if (state.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.onInsideBlock(state);
        }
    }
}

