/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.core;

import com.mojang.serialization.MapCodec;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.impl.WailaClientRegistration;

public abstract class ObjectNameProvider
implements IToggleableProvider {
    private static final MapCodec<Component> GIVEN_NAME_CODEC = ComponentSerialization.CODEC.fieldOf("given_name");

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static Component getEntityName(Entity entity) {
        if (!entity.hasCustomName()) {
            Display.BlockDisplay blockDisplay;
            Display.ItemDisplay itemDisplay;
            ItemStack stack;
            if (WailaClientRegistration.instance().shouldPick(entity) && (stack = entity.getPickResult()) != null && !stack.isEmpty()) {
                return stack.getHoverName();
            }
            if (entity instanceof Player) {
                return entity.getDisplayName();
            }
            if (entity instanceof Villager) {
                return entity.getType().getDescription();
            }
            if (entity instanceof ItemEntity) {
                return ((ItemEntity)entity).getItem().getHoverName();
            }
            if (entity instanceof Display.ItemDisplay && !(itemDisplay = (Display.ItemDisplay)entity).getSlot(0).get().isEmpty()) {
                return itemDisplay.getSlot(0).get().getHoverName();
            }
            if (entity instanceof Display.BlockDisplay && !(blockDisplay = (Display.BlockDisplay)entity).getBlockState().isAir()) {
                return blockDisplay.getBlockState().getBlock().getName();
            }
        }
        return entity.getName();
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.CORE_OBJECT_NAME;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getDefaultPriority() {
        return -10100;
    }

    public static class ForBlock
    extends ObjectNameProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ItemStack pick;
            Object name = accessor.readData(GIVEN_NAME_CODEC).orElse(null);
            if (name == null && accessor.isFakeBlock()) {
                name = accessor.getFakeBlock().getHoverName();
            }
            if (name == null && WailaClientRegistration.instance().shouldPick(accessor.getBlockState()) && (pick = accessor.getPickedResult()) != null && !pick.isEmpty()) {
                name = pick.getHoverName();
            }
            if (name == null) {
                ItemStack pick2;
                String key = accessor.getBlock().getDescriptionId();
                name = I18n.exists((String)key) ? accessor.getBlock().getName() : ((pick2 = accessor.getPickedResult()) != null && !pick2.isEmpty() ? pick2.getHoverName() : Component.literal((String)key));
            }
            tooltip.add((Component)IThemeHelper.get().title(name));
        }

        @Override
        public void appendServerData(CompoundTag data, BlockAccessor accessor) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof Nameable) {
                Nameable nameable = (Nameable)blockEntity;
                Component name = null;
                if (blockEntity instanceof ChestBlockEntity && accessor.getBlock() instanceof ChestBlock) {
                    MenuProvider menuProvider = accessor.getBlockState().getMenuProvider(accessor.getLevel(), accessor.getPosition());
                    if (menuProvider != null) {
                        name = menuProvider.getDisplayName();
                    }
                } else if (nameable.hasCustomName()) {
                    name = nameable.getDisplayName();
                }
                if (name != null) {
                    accessor.writeData(GIVEN_NAME_CODEC, name);
                }
            }
        }

        @Override
        public boolean shouldRequestData(BlockAccessor accessor) {
            return accessor.getBlockEntity() instanceof Nameable;
        }
    }

    public static class ForEntity
    extends ObjectNameProvider
    implements IEntityComponentProvider {
        private static final ForEntity INSTANCE = new ForEntity();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            Component name = ForEntity.getEntityName(accessor.getEntity());
            tooltip.add((Component)IThemeHelper.get().title(name));
        }
    }
}

