/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.WailaExceptionHandler;

public abstract class ProgressProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.getServerData().contains("JadeProgress")) {
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(ResourceLocation.tryParse((String)accessor.getServerData().getString("JadeProgressUid"))).map(WailaClientRegistration.instance().progressProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeProgress", Function.identity()));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip, provider.getUid().getNamespace());
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        BoxStyle.GradientBorder boxStyle = BoxStyle.getTransparent().clone();
        boxStyle.bgColor = 0x44FFFFFF;
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (ProgressView view : group.views) {
                if (view.text != null) {
                    theTooltip.add(helper.text(view.text).scale(0.75f));
                    theTooltip.setLineMargin(-1, ScreenDirection.DOWN, 0);
                }
                theTooltip.add(helper.progress(view.progress, null, view.style, boxStyle, false).size(new Vec2(10.0f, 2.0f)));
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        CompoundTag tag = accessor.getServerData();
        Object target = accessor.getTarget();
        for (IServerExtensionProvider provider : WailaCommonRegistration.instance().progressProviders.get(target)) {
            List groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null, provider.getUid().getNamespace());
                continue;
            }
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeProgress", groups, Function.identity())) {
                tag.putString("JadeProgressUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        ProgressProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag data, T accessor) {
        ProgressProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        for (IServerExtensionProvider<CompoundTag> provider : WailaCommonRegistration.instance().progressProviders.get((Accessor<?>)accessor)) {
            if (!provider.shouldRequestData((Accessor<?>)accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.UNIVERSAL_PROGRESS;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    public static class ForBlock
    extends ProgressProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends ProgressProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }
}

