/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum ChiseledBookshelfProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    public static final MapCodec<ItemStack> BOOK_CODEC;

    private static ItemStack getHitBook(BlockAccessor accessor) {
        if (accessor.showDetails()) {
            return ItemStack.EMPTY;
        }
        Optional<ItemStack> result = accessor.readData(BOOK_CODEC);
        return result.orElse(ItemStack.EMPTY);
    }

    @Override
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        ItemStack item = ChiseledBookshelfProvider.getHitBook(accessor);
        return item.isEmpty() ? null : IElementHelper.get().item(item);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack item = ChiseledBookshelfProvider.getHitBook(accessor);
        if (item.isEmpty()) {
            return;
        }
        tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE);
        tooltip.add((Component)IDisplayHelper.get().stripColor(item.getHoverName()));
        if (item.has(DataComponents.STORED_ENCHANTMENTS)) {
            ArrayList list = Lists.newArrayList();
            ((ItemEnchantments)item.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).addToTooltip(Item.TooltipContext.of((Level)accessor.getLevel()), list::add, (TooltipFlag)TooltipFlag.NORMAL);
            tooltip.addAll(list);
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity bookshelf = (ChiseledBookShelfBlockEntity)blockEntity;
            int slot = ((ChiseledBookShelfBlock)accessor.getBlock()).getHitSlot((BlockHitResult)accessor.getHitResult(), accessor.getBlockState()).orElse(-1);
            if (slot == -1) {
                return;
            }
            ItemStack book = bookshelf.getItem(slot);
            if (!book.isEmpty()) {
                accessor.writeData(BOOK_CODEC, book);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_CHISELED_BOOKSHELF;
    }

    @Override
    public int getDefaultPriority() {
        return ItemStorageProvider.getBlock().getDefaultPriority() + 1;
    }

    static {
        BOOK_CODEC = ItemStack.CODEC.fieldOf("book");
    }
}

