/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public enum CommandBlockProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().contains("Command")) {
            return;
        }
        tooltip.add((Component)Component.literal((String)("> " + accessor.getServerData().getString("Command"))));
    }

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        Player player = accessor.getPlayer();
        if (!player.canUseGameMasterBlocks()) {
            return;
        }
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof CommandBlockEntity) {
            CommandBlockEntity commandBlock = (CommandBlockEntity)blockEntity;
            BaseCommandBlock logic = commandBlock.getCommandBlock();
            Object command = logic.getCommand();
            if (((String)command).isEmpty()) {
                return;
            }
            if (((String)command).length() > 40) {
                command = ((String)command).substring(0, 37) + "...";
            }
            tag.putString("Command", (String)command);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_COMMAND_BLOCK;
    }
}

