/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum StatusEffectsProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final MapCodec<List<MobEffectInstance>> EFFECTS_CODEC;

    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = ((MobEffect)mobEffectInstance.getEffect().value()).getDisplayName().copy();
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9) {
            mutableComponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (mobEffectInstance.getAmplifier() + 1))));
        }
        return mutableComponent;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Optional<List<MobEffectInstance>> result = accessor.readData(EFFECTS_CODEC);
        if (result.isEmpty() || result.get().isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        ITooltip box = helper.tooltip();
        for (MobEffectInstance effect : result.get()) {
            Component name = StatusEffectsProvider.getEffectName(effect);
            String duration = effect.isInfiniteDuration() ? I18n.get((String)"effect.duration.infinite", (Object[])new Object[0]) : StringUtil.formatTickDuration((int)effect.getDuration(), (float)accessor.tickRate());
            MutableComponent s = Component.translatable((String)"jade.potion", (Object[])new Object[]{name, duration});
            IThemeHelper t = IThemeHelper.get();
            box.add((Component)(((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL ? t.danger(s) : t.success(s)));
        }
        tooltip.add(helper.box(box, BoxStyle.getNestedBox()));
    }

    @Override
    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        LivingEntity living = (LivingEntity)accessor.getEntity();
        Collection effects = living.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        List<MobEffectInstance> effectList = effects.stream().filter(MobEffectInstance::isVisible).toList();
        if (effectList.isEmpty()) {
            return;
        }
        accessor.writeData(EFFECTS_CODEC, effectList);
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_POTION_EFFECTS;
    }

    static {
        EFFECTS_CODEC = MobEffectInstance.CODEC.listOf().fieldOf("mob_effects");
    }
}

