/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;

@ApiStatus.NonExtendable
public interface ITooltip {
    public void clear();

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void add(Component component) {
        this.add(component, null);
    }

    default public void add(Component component, ResourceLocation tag) {
        this.add(this.size(), component, tag);
    }

    default public void add(int index, Component component) {
        this.add(index, component, null);
    }

    default public void add(int index, Component component, ResourceLocation tag) {
        this.add(index, IElementHelper.get().text(component).tag(tag));
    }

    default public void addAll(List<Component> components) {
        components.forEach(this::add);
    }

    default public void add(IElement element) {
        this.add(this.size(), element);
    }

    default public void add(int index, List<IElement> elements) {
        boolean first = true;
        for (IElement element : elements) {
            if (first) {
                this.add(index, element);
            } else {
                this.append(index, element);
            }
            first = false;
        }
    }

    default public void add(List<IElement> elements) {
        this.add(this.size(), elements);
    }

    public void add(int var1, IElement var2);

    default public void append(Component component) {
        this.append(component, null);
    }

    default public void append(Component component, ResourceLocation tag) {
        this.append(IElementHelper.get().text(component).tag(tag));
    }

    default public void append(IElement element) {
        this.append(this.size() - 1, element);
    }

    default public void append(int index, List<IElement> elements) {
        for (IElement element : elements) {
            this.append(index, element);
        }
    }

    public void append(int var1, IElement var2);

    public boolean remove(ResourceLocation var1);

    public boolean replace(ResourceLocation var1, UnaryOperator<List<List<IElement>>> var2);

    public boolean replace(ResourceLocation var1, Component var2);

    public List<IElement> get(ResourceLocation var1);

    public List<IElement> get(int var1, IElement.Align var2);

    public String getMessage();

    public void setLineMargin(int var1, ScreenDirection var2, int var3);
}

