/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.SmoothChasingValue;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    public static final Component OPTION_ON = CommonComponents.OPTION_ON.copy().withStyle(style -> style.withColor(-4589878));
    public static final Component OPTION_OFF = CommonComponents.OPTION_OFF.copy().withStyle(style -> style.withColor(-30080));
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final Runnable diskWriter;
    public Title currentTitle;
    public KeyMapping selectedKey;
    private BaseOptionsScreen owner;
    private final SmoothChasingValue smoothScroll;
    private Entry defaultParent;

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y0, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.smoothScroll = new SmoothChasingValue().withSpeed(0.6f);
    }

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int entryHeight) {
        this(owner, client, width, height, y0, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int getRowWidth() {
        return Math.min(this.width, 300);
    }

    protected int getScrollbarPosition() {
        return this.owner.width - 6;
    }

    public void setScrollAmount(double scroll) {
        this.smoothScroll.target(Mth.clamp((float)((float)scroll), (float)0.0f, (float)this.getMaxScroll()));
    }

    public void forceSetScrollAmount(double scroll) {
        this.smoothScroll.start((float)scroll);
        super.setScrollAmount(scroll);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double speed = !ClientProxy.hasFastScroll && Screen.hasControlDown() ? 4.5 : 1.5;
        this.setScrollAmount((double)this.smoothScroll.getTarget() - deltaY * (double)this.itemHeight * speed);
        return true;
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        this.smoothScroll.value = this.smoothScroll.getTarget();
        super.setScrollAmount((double)this.smoothScroll.value);
        return super.mouseDragged(d, e, i, f, g);
    }

    public boolean isFocused() {
        return this.owner.getFocused() == this;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        FocusNavigationEvent.ArrowNavigation nav;
        OptionsNav.Entry navEntry = (OptionsNav.Entry)this.owner.getOptionsNav().getFocused();
        if (navEntry != null && event instanceof FocusNavigationEvent.ArrowNavigation && (nav = (FocusNavigationEvent.ArrowNavigation)event).direction() == ScreenDirection.RIGHT) {
            Title title = navEntry.getTitle();
            this.setFocused((GuiEventListener)title);
            ComponentPath path = super.nextFocusPath((FocusNavigationEvent)new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN));
            this.setFocused(null);
            return path;
        }
        return super.nextFocusPath(event);
    }

    public void ensureVisible(Entry entry) {
        super.ensureVisible((AbstractSelectionList.Entry)entry);
    }

    protected boolean isSelectedItem(int i) {
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return false;
        }
        return Objects.equals(this.getSelected(), this.children().get(i));
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        ResourceLocation resourceLocation2 = this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        guiGraphics.blit(resourceLocation2, 0, this.getBottom(), 0.0f, 0.0f, this.owner.width, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    protected void renderSelection(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        guiGraphics.fill(this.getX(), i - 2, this.getRight(), i + k + 2, 0x33FFFFFF);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float deltaTicks = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        this.smoothScroll.tick(deltaTicks);
        super.setScrollAmount((double)this.smoothScroll.value);
        this.hovered = null;
        if (!PreviewOptionsScreen.isAdjustingPosition()) {
            InputType lastInputType = this.minecraft.getLastInputType();
            mouseY = Math.min(mouseY, this.getRowRight());
            if (lastInputType.isMouse() && this.isMouseOver(mouseX, mouseY)) {
                this.hovered = this.getEntryAtPosition(mouseX, mouseY);
            } else if (lastInputType.isKeyboard() && this.getFocused() != null) {
                this.hovered = this.getFocused();
            }
            AbstractSelectionList.Entry entry = this.hovered;
            if (entry instanceof Title) {
                Title title = (Title)entry;
                this.setSelected(null);
                this.currentTitle = title;
            } else {
                Entry entry2;
                this.setSelected((AbstractSelectionList.Entry)((Entry)this.hovered));
                if (this.hovered != null && (entry2 = ((Entry)this.hovered).root()) instanceof Title) {
                    Title title;
                    this.currentTitle = title = (Title)entry2;
                }
            }
        }
        this.enableScissor(guiGraphics);
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.disableScissor();
        this.renderListSeparators(guiGraphics);
        if (this.scrollbarVisible()) {
            int k = this.getScrollbarPosition();
            int l = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
            l = Mth.clamp((int)l, (int)32, (int)(this.height - 8));
            int m = (int)this.getScrollAmount() * (this.height - l) / this.getMaxScroll() + this.getY();
            if (m < this.getY()) {
                m = this.getY();
            }
            RenderSystem.enableBlend();
            guiGraphics.blitSprite(SCROLLER_BACKGROUND_SPRITE, k, this.getY(), 6, this.getHeight());
            guiGraphics.blitSprite(SCROLLER_SPRITE, k, m, 6, l);
            RenderSystem.disableBlend();
        }
        this.renderDecorations(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    public void save() {
        this.children().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    @Nullable
    public Entry getEntryAt(double x, double y) {
        return (Entry)this.getEntryAtPosition(x, y);
    }

    public int getRowTop(int i) {
        return super.getRowTop(i);
    }

    public int getRowBottom(int i) {
        return super.getRowBottom(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public MutableComponent title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter) {
        return this.slider(optionName, value, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, value, setter, min, max, aligner));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, value, setter, validator));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter) {
        return this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter) {
        return this.choices(optionName, value, setter, null);
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter, @Nullable Consumer<CycleButton.Builder<Boolean>> builderConsumer) {
        CycleButton.Builder builder = CycleButton.booleanBuilder((Component)OPTION_ON, (Component)OPTION_OFF);
        if (builderConsumer != null) {
            builderConsumer.accept((CycleButton.Builder<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (CycleButton.Builder<Boolean>)builder, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter) {
        return this.choices(optionName, value, setter, null);
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter, @Nullable Consumer<CycleButton.Builder<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])value.getDeclaringClass().getEnumConstants());
        CycleButton.Builder builder = CycleButton.builder(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }).withValues(values);
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, value, setter));
    }

    public <T> OptionValue<T> choices(String optionName, T value, List<T> values, Consumer<T> setter, Function<T, Component> nameProvider) {
        return this.add(new CycleOptionValue<T>(optionName, CycleButton.builder(nameProvider).withValues(values), value, setter));
    }

    public void keybind(KeyMapping keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.clearEntries();
        this.owner = null;
    }

    public void updateSearch(String search) {
        this.clearEntries();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            block1: for (String keyword : keywords) {
                keyword = keyword.toLowerCase(Locale.ENGLISH);
                for (String message : entry.getMessages()) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent() != null) {
                entry = entry.parent();
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.addEntry((AbstractSelectionList.Entry)entry);
        }
        if (matches.isEmpty()) {
            this.addEntry((AbstractSelectionList.Entry)new Title(Component.translatable((String)"gui.jade.no_results").withStyle(ChatFormatting.GRAY)));
        }
    }

    public void updateSaveState() {
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.owner.saveButton.active = false;
            return;
        }
        this.owner.saveButton.active = true;
    }

    public void showOnTop(Entry entry) {
        this.setScrollAmount(this.itemHeight * this.children().indexOf((Object)entry) + 1);
        if (entry instanceof Title) {
            Title title;
            this.currentTitle = title = (Title)entry;
        }
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.selectedKey != null) {
            Options options = Minecraft.getInstance().options;
            if (i == 256) {
                options.setKey(this.selectedKey, InputConstants.UNKNOWN);
            } else {
                options.setKey(this.selectedKey, InputConstants.getKey((int)i, (int)j));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.selectedKey != null) {
            Options options = Minecraft.getInstance().options;
            options.setKey(this.selectedKey, InputConstants.Type.MOUSE.getOrCreate(i));
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
        }
        return super.mouseClicked(d, e, i);
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client;
        private final List<String> messages = Lists.newArrayList();
        private final List<AbstractWidget> widgets = Lists.newArrayList();
        private final List<Vector2i> widgetOffsets = Lists.newArrayList();
        protected List<Component> description = List.of();
        private Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = Minecraft.getInstance();
        }

        public static MutableComponent makeTitle(String key) {
            return Component.translatable((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return Util.makeDescriptionId((String)"config", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jade", (String)key));
        }

        public AbstractWidget getFirstWidget() {
            return this.widgets.isEmpty() ? null : this.widgets.getFirst();
        }

        public void addWidget(AbstractWidget widget, int offsetX) {
            this.addWidget(widget, offsetX, -widget.getHeight() / 2);
        }

        public void addWidget(AbstractWidget widget, int offsetX, int offsetY) {
            this.widgets.add(widget);
            this.widgetOffsets.add(new Vector2i(offsetX, offsetY));
        }

        public List<? extends AbstractWidget> children() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children();
        }

        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (AbstractWidget widget : this.widgets) {
                Vector2i offset = this.widgetOffsets.get(this.widgets.indexOf(widget));
                widget.setX(rowLeft + width - 110 + offset.x);
                widget.setY(rowTop + height / 2 + offset.y);
                widget.render(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean b) {
            for (AbstractWidget widget : this.widgets) {
                boolean bl = widget.active = !b;
                if (!(widget instanceof EditBox)) continue;
                EditBox box = (EditBox)widget;
                box.setEditable(!b);
            }
        }

        public List<Component> getDescription() {
            return this.description;
        }

        public List<Component> getDescriptionOnShift() {
            return List.of();
        }

        public int getTextX(int width) {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public Entry parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
            return this;
        }

        public Entry parent() {
            return this.parent;
        }

        public Entry root() {
            Entry entry = this;
            while (entry.parent() != null) {
                entry = entry.parent();
            }
            return entry;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(StringUtil.stripColor((String)message));
        }

        public void addMessageKey(String key) {
            if (I18n.exists((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(I18n.get((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        public Component narration;
        private final MutableComponent title;
        private int x;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (I18n.exists((String)key)) {
                this.description = List.of(Component.translatable((String)key));
                this.addMessage(((Component)this.description.getFirst()).getString());
            }
            this.narration = Component.translatable((String)"narration.jade.category", (Object[])new Object[]{this.title});
        }

        public Title(MutableComponent title) {
            this.title = title;
            this.narration = title;
        }

        public MutableComponent getTitle() {
            return this.title;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.x = rowLeft;
            Font font = this.client.font;
            int n = this.getTextX(width);
            Objects.requireNonNull(this.client.font);
            guiGraphics.drawString(font, (Component)this.title, n, rowTop + height - 9, 0xFFFFFF);
        }

        @Override
        public int getTextX(int width) {
            return this.x + (width - this.client.font.width((FormattedText)this.title)) / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.font.width((FormattedText)this.title);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.add(NarratedElementType.TITLE, narration);
                }
            });
        }
    }
}

