/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorClientHandler
implements AccessorClientHandler<EntityAccessor> {
    @Override
    public boolean shouldDisplay(EntityAccessor accessor) {
        IWailaConfig.IConfigGeneral general = IWailaConfig.get().getGeneral();
        if (!general.getDisplayEntities()) {
            return false;
        }
        return general.getDisplayBosses() || !CommonProxy.isBoss(accessor.getEntity());
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        for (IServerDataProvider<EntityAccessor> provider : WailaCommonRegistration.instance().getEntityNBTProviders(accessor.getEntity())) {
            if (!provider.shouldRequestData(accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void requestData(EntityAccessor accessor) {
        ClientProxy.requestEntityData(accessor);
    }

    @Override
    public IElement getIcon(EntityAccessor accessor) {
        IElement icon = null;
        Entity entity = accessor.getEntity();
        if (entity instanceof ItemEntity) {
            icon = ItemStackElement.of(((ItemEntity)entity).getItem());
        } else {
            ItemStack stack = accessor.getPickedResult();
            if (!(stack.getItem() instanceof SpawnEggItem) || !(entity instanceof LivingEntity)) {
                icon = ItemStackElement.of(stack);
            }
        }
        for (IComponentProvider<EntityAccessor> provider : WailaClientRegistration.instance().getEntityIconProviders(entity, PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(accessor, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherComponents(EntityAccessor accessor, Function<IJadeProvider, ITooltip> tooltipProvider) {
        for (IComponentProvider<EntityAccessor> provider : WailaClientRegistration.instance().getEntityProviders(accessor.getEntity(), PluginConfig.INSTANCE::get)) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, accessor, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip, null);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }
}

