/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import snownee.jade.Jade;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.entry.ConfigEntry;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.ModIdentification;

public class PluginConfig
implements IPluginConfig {
    public static final PluginConfig INSTANCE = new PluginConfig();
    public static final String CLIENT_FILE = "jade/plugins.json";
    public static final String SERVER_FILE = "jade/server-plugin-overrides.json";
    private final Map<ResourceLocation, ConfigEntry<Object>> configs = Maps.newHashMap();
    private final Multimap<ResourceLocation, Component> categoryOverrides = ArrayListMultimap.create();
    private JsonObject serverConfigs;

    private PluginConfig() {
    }

    public static boolean isPrimaryKey(ResourceLocation key) {
        return !key.getPath().contains(".");
    }

    public static ResourceLocation getPrimaryKey(ResourceLocation key) {
        return key.withPath(key.getPath().substring(0, key.getPath().indexOf(46)));
    }

    public void addConfig(ConfigEntry<?> entry) {
        Preconditions.checkArgument((StringUtils.countMatches((CharSequence)entry.getId().getPath(), (char)'.') <= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.containsKey(entry.getId()) ? 1 : 0) != 0, (String)"Duplicate config key: %s", (Object)entry.getId());
        Preconditions.checkArgument((boolean)entry.isValidValue(entry.getDefaultValue()), (String)"Default value of config %s does not pass value check", (Object)entry.getId());
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<ResourceLocation> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.getNamespace().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean get(IToggleableProvider provider) {
        if (provider.isRequired()) {
            return true;
        }
        return this.get(provider.getUid());
    }

    @Override
    public boolean get(ResourceLocation key) {
        if (CommonProxy.isPhysicallyClient()) {
            return (Boolean)this.getEntry(key).getValue();
        }
        return Optional.ofNullable(this.serverConfigs).map($ -> $.getAsJsonObject(key.getNamespace())).map($ -> $.get(key.getPath())).map(JsonElement::getAsBoolean).orElse(false);
    }

    @Override
    public <T extends Enum<T>> T getEnum(ResourceLocation key) {
        return (T)((Enum)this.getEntry(key).getValue());
    }

    @Override
    public int getInt(ResourceLocation key) {
        return (Integer)this.getEntry(key).getValue();
    }

    @Override
    public float getFloat(ResourceLocation key) {
        return ((Float)this.getEntry(key).getValue()).floatValue();
    }

    @Override
    public String getString(ResourceLocation key) {
        return (String)this.getEntry(key).getValue();
    }

    public ConfigEntry<?> getEntry(ResourceLocation key) {
        return this.configs.get(key);
    }

    public boolean set(ResourceLocation key, Object value) {
        Objects.requireNonNull(value);
        ConfigEntry<?> entry = this.getEntry(key);
        if (entry == null) {
            Jade.LOGGER.warn("Skip setting value for unknown option: {}, {}", (Object)key, value);
            return false;
        }
        if (!entry.isValidValue(value)) {
            Jade.LOGGER.warn("Skip setting illegal value for option: {}, {}", (Object)key, value);
            return false;
        }
        entry.setValue(value);
        return true;
    }

    public File getFile() {
        boolean client = CommonProxy.isPhysicallyClient();
        return new File(CommonProxy.getConfigDirectory(), client ? CLIENT_FILE : SERVER_FILE);
    }

    public void reload() {
        boolean client = CommonProxy.isPhysicallyClient();
        File configFile = this.getFile();
        if (client) {
            this.configs.values().forEach($ -> $.setSynced(false));
        }
        if (!configFile.exists()) {
            this.writeConfig(configFile, true);
        }
        if (client) {
            Map config;
            try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
                config = (Map)JsonConfig.GSON.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Object>>>(this){}.getType());
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to read client plugin config file", (Throwable)e);
                config = Maps.newHashMap();
            }
            MutableBoolean saveFlag = new MutableBoolean();
            HashSet found = Sets.newHashSet();
            config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                if (!this.configs.containsKey(id)) {
                    return;
                }
                if (!this.set(id, value)) {
                    saveFlag.setTrue();
                }
                found.add(id);
            }));
            Set<ResourceLocation> allKeys = this.getKeys();
            for (ResourceLocation id : allKeys) {
                if (found.contains(id)) continue;
                this.set(id, this.getEntry(id).getDefaultValue());
                saveFlag.setTrue();
            }
            if (saveFlag.isTrue()) {
                this.save();
            }
        } else {
            try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
                this.serverConfigs = (JsonObject)JsonConfig.GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to read server plugin config file", (Throwable)e);
                this.serverConfigs = null;
            }
        }
    }

    public void save() {
        this.writeConfig(this.getFile(), false);
    }

    private void writeConfig(File file, boolean reset) {
        String json;
        boolean client = CommonProxy.isPhysicallyClient();
        if (client) {
            HashMap config = Maps.newHashMap();
            this.configs.values().forEach(e -> {
                Map modConfig = config.computeIfAbsent(e.getId().getNamespace(), k -> Maps.newHashMap());
                if (reset) {
                    e.setValue(e.getDefaultValue());
                }
                modConfig.put(e.getId().getPath(), e.getValue());
            });
            json = JsonConfig.GSON.toJson((Object)config);
        } else {
            json = "{}";
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write(json);
        }
        catch (IOException e2) {
            Jade.LOGGER.error("Failed to write plugin config file", (Throwable)e2);
        }
    }

    public void applyServerConfigs(JsonObject json) {
        json.keySet().forEach(namespace -> json.getAsJsonObject(namespace).entrySet().forEach(entry -> {
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)((String)entry.getKey()));
            ConfigEntry<?> configEntry = this.getEntry(key);
            if (configEntry != null) {
                Object v;
                JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    v = primitive.getAsBoolean();
                } else if (primitive.isNumber()) {
                    v = primitive.getAsNumber();
                } else if (primitive.isString()) {
                    v = primitive.getAsString();
                } else {
                    return;
                }
                if (configEntry.isValidValue(v)) {
                    configEntry.setValue(v);
                    configEntry.setSynced(true);
                }
            }
        }));
    }

    public String getServerConfigs() {
        return this.serverConfigs == null ? "" : this.serverConfigs.toString();
    }

    public boolean containsKey(ResourceLocation uid) {
        return this.configs.containsKey(uid);
    }

    public void addConfigListener(ResourceLocation key, Consumer<ResourceLocation> listener) {
        Preconditions.checkArgument((boolean)this.containsKey(key));
        this.configs.get(key).addListener(listener);
    }

    public void setCategoryOverride(ResourceLocation key, Component override) {
        Preconditions.checkArgument((boolean)this.containsKey(key), (String)"Unknown config key: %s", (Object)key);
        Preconditions.checkArgument((boolean)PluginConfig.isPrimaryKey(key), (Object)"Only primary config key can be overridden");
        this.categoryOverrides.put((Object)key, (Object)override);
    }

    public void setCategoryOverride(ResourceLocation key, List<Component> overrides) {
        Preconditions.checkArgument((boolean)this.containsKey(key), (String)"Unknown config key: %s", (Object)key);
        Preconditions.checkArgument((boolean)PluginConfig.isPrimaryKey(key), (Object)"Only primary config key can be overridden");
        this.categoryOverrides.putAll((Object)key, overrides);
    }

    public List<Category> getListView() {
        ArrayListMultimap categoryMap = ArrayListMultimap.create();
        this.categoryOverrides.forEach((arg_0, arg_1) -> this.lambda$getListView$10((Multimap)categoryMap, arg_0, arg_1));
        this.configs.forEach((arg_0, arg_1) -> this.lambda$getListView$11((Multimap)categoryMap, arg_0, arg_1));
        return categoryMap.asMap().entrySet().stream().map(e -> new Category(Component.literal((String)((String)e.getKey())), ((Collection)e.getValue()).stream().sorted(Comparator.comparingInt($ -> WailaCommonRegistration.instance().priorities.getSortedList().indexOf((Object)$.getId()))).toList())).sorted(Comparator.comparingInt(PluginConfig.specialOrder()).thenComparing($ -> $.title.getString())).toList();
    }

    private static ToIntFunction<Category> specialOrder() {
        String core = I18n.get((String)OptionsList.Entry.makeKey("plugin_jade"), (Object[])new Object[0]);
        String debug = I18n.get((String)OptionsList.Entry.makeKey("plugin_jade.debug"), (Object[])new Object[0]);
        return category -> {
            String title = category.title.getString();
            if (core.equals(title)) {
                return -1;
            }
            if (debug.equals(title)) {
                return 1;
            }
            return 0;
        };
    }

    private /* synthetic */ void lambda$getListView$11(Multimap categoryMap, ResourceLocation key, ConfigEntry entry) {
        ResourceLocation primaryKey;
        Collection components;
        if (this.categoryOverrides.containsKey((Object)key)) {
            return;
        }
        if (!PluginConfig.isPrimaryKey(key) && !(components = this.categoryOverrides.get((Object)(primaryKey = PluginConfig.getPrimaryKey(key)))).isEmpty()) {
            for (Component component : components) {
                categoryMap.put((Object)component.getString(), (Object)entry);
            }
            return;
        }
        String namespace = key.getNamespace();
        Optional<String> modName = ModIdentification.getModName(namespace);
        if (!"jade".equals(namespace) && modName.isPresent()) {
            categoryMap.put((Object)modName.get(), (Object)entry);
        } else {
            categoryMap.put((Object)I18n.get((String)OptionsList.Entry.makeKey("plugin_" + namespace), (Object[])new Object[0]), (Object)entry);
        }
    }

    private /* synthetic */ void lambda$getListView$10(Multimap categoryMap, ResourceLocation key, Component component) {
        categoryMap.put((Object)component.getString(), this.getEntry(key));
    }

    public record Category(MutableComponent title, List<ConfigEntry<?>> entries) {
    }
}

