/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.network.ClientPayloadContext;
import snownee.jade.util.JsonConfig;

public record ServerPingPacket(String serverConfig, List<Block> shearableBlocks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerPingPacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_SERVER_PING);
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerPingPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerPingPacket::serverConfig, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).apply(ByteBufCodecs.list()), ServerPingPacket::shearableBlocks, ServerPingPacket::new);

    public static void handle(ServerPingPacket message, ClientPayloadContext context) {
        JsonObject json;
        String s = message.serverConfig;
        try {
            json = s.isEmpty() ? null : (JsonObject)JsonConfig.GSON.fromJson(s, JsonObject.class);
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Received malformed config from the server: {}", (Object)s);
            return;
        }
        context.execute(() -> {
            ObjectDataCenter.serverConnected = true;
            PluginConfig.INSTANCE.reload();
            if (json != null && !json.keySet().isEmpty()) {
                PluginConfig.INSTANCE.applyServerConfigs(json);
            }
            HarvestToolProvider.INSTANCE.setShearableBlocks(message.shearableBlocks);
            Jade.LOGGER.info("Received config from the server: {}", (Object)s);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

