/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.util.CommonProxy;

public class RayTracing {
    public static final RayTracing INSTANCE = new RayTracing();
    public static Predicate<Entity> ENTITY_FILTER = entity -> true;
    private final Minecraft mc = Minecraft.getInstance();
    private HitResult target = null;

    private RayTracing() {
    }

    public static BlockState wrapBlock(BlockGetter level, BlockHitResult hit, CollisionContext context) {
        if (hit.getType() != HitResult.Type.BLOCK) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState blockState = level.getBlockState(hit.getBlockPos());
        FluidState fluidState = blockState.getFluidState();
        if (!fluidState.isEmpty()) {
            if (blockState.is(Blocks.BARRIER) && WailaClientRegistration.instance().shouldHide(blockState)) {
                return fluidState.createLegacyBlock();
            }
            if (blockState.getShape(level, hit.getBlockPos(), context).isEmpty()) {
                return fluidState.createLegacyBlock();
            }
        }
        return blockState;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.getEntities(projectile, boundingBox, filter)) {
            double d1;
            AABB axisalignedbb = entity1.getBoundingBox();
            if (axisalignedbb.getSize() < 0.3) {
                axisalignedbb = axisalignedbb.inflate(0.3);
            }
            if (axisalignedbb.contains(startVec)) {
                entity = entity1;
                break;
            }
            Optional optional = axisalignedbb.clip(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.distanceToSqr((Vec3)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    public static boolean isEmptyElement(IElement element) {
        return element == null || element == ItemStackElement.EMPTY;
    }

    public void fire() {
        Entity targetEntity;
        Player viewPlayer;
        Entity viewEntity = this.mc.getCameraEntity();
        Object object = viewPlayer = viewEntity instanceof Player ? (Player)viewEntity : this.mc.player;
        if (viewEntity == null || viewPlayer == null) {
            return;
        }
        if (this.mc.hitResult != null && this.mc.hitResult.getType() == HitResult.Type.ENTITY && this.canBeTarget(targetEntity = ((EntityHitResult)this.mc.hitResult).getEntity(), viewEntity)) {
            this.target = this.mc.hitResult;
            return;
        }
        float extendedReach = IWailaConfig.get().getGeneral().getExtendedReach();
        double blockReach = viewPlayer.blockInteractionRange() + (double)extendedReach;
        double entityReach = viewPlayer.entityInteractionRange() + (double)extendedReach;
        this.target = this.rayTrace(viewEntity, blockReach, entityReach, this.mc.getTimer().getGameTimeDeltaPartialTick(true));
    }

    public HitResult getTarget() {
        return this.target;
    }

    public HitResult rayTrace(Entity entity, double blockReach, double entityReach, float partialTicks) {
        Vec3 eyePosition = entity.getEyePosition(partialTicks);
        Vec3 lookVector = entity.getViewVector(partialTicks);
        if (this.mc.hitResult != null && this.mc.hitResult.getType() == HitResult.Type.BLOCK) {
            blockReach = entityReach = this.mc.hitResult.getLocation().distanceTo(eyePosition) + 0.1;
        }
        Vec3 traceEnd = eyePosition.add(lookVector.scale(entityReach));
        Level world = entity.level();
        AABB bound = new AABB(eyePosition, traceEnd);
        Predicate<Entity> predicate = e -> this.canBeTarget((Entity)e, entity);
        EntityHitResult entityResult = RayTracing.getEntityHitResult(world, entity, eyePosition, traceEnd, bound, predicate);
        if (blockReach != entityReach) {
            traceEnd = eyePosition.add(lookVector.scale(blockReach));
        }
        BlockState eyeBlock = world.getBlockState(BlockPos.containing((Position)eyePosition));
        ClipContext.Fluid fluidView = ClipContext.Fluid.NONE;
        IWailaConfig.FluidMode fluidMode = IWailaConfig.get().getGeneral().getDisplayFluids();
        if (eyeBlock.getFluidState().isEmpty()) {
            fluidView = fluidMode.ctx;
        }
        CollisionContext collisionContext = CollisionContext.of((Entity)entity);
        ClipContext context = new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, fluidView, collisionContext);
        BlockHitResult blockResult = world.clip(context);
        if (entityResult != null) {
            if (blockResult.getType() == HitResult.Type.BLOCK) {
                double blockDist;
                double entityDist = entityResult.getLocation().distanceToSqr(eyePosition);
                if (entityDist < (blockDist = blockResult.getLocation().distanceToSqr(eyePosition))) {
                    return entityResult;
                }
            } else {
                return entityResult;
            }
        }
        if (blockResult.getType() == HitResult.Type.BLOCK) {
            BlockState state = RayTracing.wrapBlock((BlockGetter)world, blockResult, collisionContext);
            if (WailaClientRegistration.instance().shouldHide(state)) {
                blockResult = null;
            }
        } else if (blockResult.getType() == HitResult.Type.MISS) {
            blockResult = null;
        }
        if (blockResult == null && fluidMode == IWailaConfig.FluidMode.FALLBACK) {
            context = new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, collisionContext);
            blockResult = world.clip(context);
            BlockState state = RayTracing.wrapBlock((BlockGetter)world, blockResult, collisionContext);
            if (WailaClientRegistration.instance().shouldHide(state)) {
                return null;
            }
            return blockResult;
        }
        return blockResult;
    }

    private boolean canBeTarget(Entity target, Entity viewEntity) {
        if (target.isRemoved()) {
            return false;
        }
        if (target.isSpectator()) {
            return false;
        }
        if (target == viewEntity.getVehicle()) {
            return false;
        }
        if (target instanceof Projectile) {
            Projectile projectile = (Projectile)target;
            if (projectile.tickCount <= 10 && !target.level().tickRateManager().isEntityFrozen(target)) {
                return false;
            }
        }
        if (CommonProxy.isMultipartEntity(target) && !target.isPickable()) {
            return false;
        }
        if (viewEntity instanceof Player) {
            Player player = (Player)viewEntity;
            if (target.isInvisibleTo(player)) {
                return false;
            }
            if (this.mc.gameMode.isDestroying() && target.getType() == EntityType.ITEM) {
                return false;
            }
        } else if (target.isInvisible()) {
            return false;
        }
        return !WailaClientRegistration.instance().shouldHide(target) && ENTITY_FILTER.test(target);
    }

    public IElement getIcon() {
        Accessor<?> accessor = ObjectDataCenter.get();
        if (accessor == null) {
            return null;
        }
        IElement icon = ObjectDataCenter.getIcon();
        if (RayTracing.isEmptyElement(icon)) {
            return null;
        }
        return icon;
    }
}

