/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public class JadeForgeUtils {
    private JadeForgeUtils() {
    }

    public static ItemIterator<? extends IItemHandler> fromItemHandler(IItemHandler storage, int fromIndex) {
        return JadeForgeUtils.fromItemHandler(storage, fromIndex, CommonProxy::findItemHandler);
    }

    public static ItemIterator<? extends IItemHandler> fromItemHandler(IItemHandler storage, int fromIndex, Function<Object, @Nullable IItemHandler> containerFinder) {
        return new ItemIterator.SlottedItemIterator<IItemHandler>(containerFinder, fromIndex){

            @Override
            protected int getSlotCount(IItemHandler container) {
                return container.getSlots();
            }

            @Override
            protected ItemStack getItemInSlot(IItemHandler container, int slot) {
                return container.getStackInSlot(slot);
            }
        };
    }

    public static JadeFluidObject fromFluidStack(FluidStack fluidStack) {
        return JadeFluidObject.of(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getComponentsPatch());
    }

    public static List<ViewGroup<CompoundTag>> fromFluidHandler(IFluidHandler fluidHandler) {
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>(fluidHandler.getTanks());
        int emptyCapacity = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            int capacity = fluidHandler.getTankCapacity(i);
            if (capacity <= 0) continue;
            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
            if (fluidStack.isEmpty()) {
                emptyCapacity = IntMath.saturatedAdd((int)emptyCapacity, (int)capacity);
                continue;
            }
            list.add(FluidView.writeDefault(JadeForgeUtils.fromFluidStack(fluidStack), capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0) {
            list.add(FluidView.writeDefault(JadeFluidObject.empty(), emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }
}

