/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.client;

import com.illusivesoulworks.polymorph.api.client.PolymorphWidgets;
import com.illusivesoulworks.polymorph.api.client.base.IRecipesWidget;
import com.illusivesoulworks.polymorph.api.client.widgets.CrafterRecipesWidget;
import com.illusivesoulworks.polymorph.api.client.widgets.FurnaceRecipesWidget;
import com.illusivesoulworks.polymorph.api.client.widgets.PlayerRecipesWidget;
import com.illusivesoulworks.polymorph.client.RecipesWidget;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;

public class PolymorphWidgetsImpl
extends PolymorphWidgets {
    public static final PolymorphWidgets INSTANCE = new PolymorphWidgetsImpl();
    private final List<PolymorphWidgets.IRecipesWidgetFactory> widgetFactories = new LinkedList<PolymorphWidgets.IRecipesWidgetFactory>();

    public static void setup() {
        INSTANCE.registerWidget(containerScreen -> {
            AbstractContainerMenu container;
            AbstractContainerMenu abstractContainerMenu = container = containerScreen.getMenu();
            Objects.requireNonNull(abstractContainerMenu);
            AbstractContainerMenu selector0$temp = abstractContainerMenu;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmithingMenu.class, AbstractFurnaceMenu.class, CrafterMenu.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    SmithingMenu smithingMenu = (SmithingMenu)selector0$temp;
                    yield new PlayerRecipesWidget(containerScreen, (Slot)container.slots.get(3));
                }
                case 1 -> {
                    AbstractFurnaceMenu abstractFurnaceMenu = (AbstractFurnaceMenu)selector0$temp;
                    yield new FurnaceRecipesWidget(containerScreen);
                }
                case 2 -> {
                    CrafterMenu crafterMenu = (CrafterMenu)selector0$temp;
                    yield new CrafterRecipesWidget(containerScreen);
                }
                default -> null;
            };
        });
    }

    @Override
    public IRecipesWidget getCurrentWidget() {
        return RecipesWidget.get().orElse(null);
    }

    @Override
    public IRecipesWidget getWidgetOrDefault(AbstractContainerScreen<?> containerScreen) {
        Slot slot;
        IRecipesWidget widget = this.getWidget(containerScreen);
        if (widget == null && (slot = this.findResultSlot(containerScreen)) != null) {
            widget = new PlayerRecipesWidget(containerScreen, slot);
        }
        return widget;
    }

    @Override
    public IRecipesWidget getWidget(AbstractContainerScreen<?> pContainerScreen) {
        for (PolymorphWidgets.IRecipesWidgetFactory factory : this.widgetFactories) {
            IRecipesWidget widget = factory.createWidget(pContainerScreen);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public void registerWidget(PolymorphWidgets.IRecipesWidgetFactory pFactory) {
        this.widgetFactories.add(pFactory);
    }

    @Override
    public Slot findResultSlot(AbstractContainerScreen<?> pContainerScreen) {
        AbstractContainerMenu container = pContainerScreen.getMenu();
        for (Slot slot : container.slots) {
            if (!(slot.container instanceof ResultContainer)) continue;
            return slot;
        }
        return null;
    }
}

