/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class FloatArgumentInfo
implements ArgumentTypeInfo<FloatArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template p_235518_, FriendlyByteBuf p_235519_) {
        boolean $$2 = p_235518_.min != -3.4028235E38f;
        boolean $$3 = p_235518_.max != Float.MAX_VALUE;
        p_235519_.writeByte(ArgumentUtils.createNumberFlags($$2, $$3));
        if ($$2) {
            p_235519_.writeFloat(p_235518_.min);
        }
        if ($$3) {
            p_235519_.writeFloat(p_235518_.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf p_235521_) {
        byte $$1 = p_235521_.readByte();
        float $$2 = ArgumentUtils.numberHasMin($$1) ? p_235521_.readFloat() : -3.4028235E38f;
        float $$3 = ArgumentUtils.numberHasMax($$1) ? p_235521_.readFloat() : Float.MAX_VALUE;
        return new Template($$2, $$3);
    }

    @Override
    public void serializeToJson(Template p_235515_, JsonObject p_235516_) {
        if (p_235515_.min != -3.4028235E38f) {
            p_235516_.addProperty("min", (Number)Float.valueOf(p_235515_.min));
        }
        if (p_235515_.max != Float.MAX_VALUE) {
            p_235516_.addProperty("max", (Number)Float.valueOf(p_235515_.max));
        }
    }

    @Override
    public Template unpack(FloatArgumentType p_235507_) {
        return new Template(p_235507_.getMinimum(), p_235507_.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        return this.deserializeFromNetwork(friendlyByteBuf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<FloatArgumentType> {
        final float min;
        final float max;

        Template(float p_235529_, float p_235530_) {
            this.min = p_235529_;
            this.max = p_235530_;
        }

        @Override
        public FloatArgumentType instantiate(CommandBuildContext p_235533_) {
            return FloatArgumentType.floatArg((float)this.min, (float)this.max);
        }

        @Override
        public ArgumentTypeInfo<FloatArgumentType, ?> type() {
            return FloatArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.instantiate(commandBuildContext);
        }
    }
}

