/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.Mth;

public class DoubleTag
extends NumericTag {
    private static final int SELF_SIZE_IN_BYTES = 16;
    public static final DoubleTag ZERO = new DoubleTag(0.0);
    public static final TagType<DoubleTag> TYPE = new TagType.StaticSize<DoubleTag>(){

        @Override
        public DoubleTag load(DataInput p_128524_, NbtAccounter p_128526_) throws IOException {
            return DoubleTag.valueOf(1.readAccounted(p_128524_, p_128526_));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197454_, StreamTagVisitor p_197455_, NbtAccounter p_302353_) throws IOException {
            return p_197455_.visit(1.readAccounted(p_197454_, p_302353_));
        }

        private static double readAccounted(DataInput p_302363_, NbtAccounter p_302397_) throws IOException {
            p_302397_.accountBytes(16L);
            return p_302363_.readDouble();
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public String getName() {
            return "DOUBLE";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Double";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final double data;

    private DoubleTag(double p_128498_) {
        this.data = p_128498_;
    }

    public static DoubleTag valueOf(double p_128501_) {
        if (p_128501_ == 0.0) {
            return ZERO;
        }
        return new DoubleTag(p_128501_);
    }

    @Override
    public void write(DataOutput p_128503_) throws IOException {
        p_128503_.writeDouble(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 16;
    }

    @Override
    public byte getId() {
        return 6;
    }

    public TagType<DoubleTag> getType() {
        return TYPE;
    }

    @Override
    public DoubleTag copy() {
        return this;
    }

    public boolean equals(Object p_128512_) {
        if (this == p_128512_) {
            return true;
        }
        return p_128512_ instanceof DoubleTag && this.data == ((DoubleTag)p_128512_).data;
    }

    public int hashCode() {
        long $$0 = Double.doubleToLongBits(this.data);
        return (int)($$0 ^ $$0 >>> 32);
    }

    @Override
    public void accept(TagVisitor p_177860_) {
        p_177860_.visitDouble(this);
    }

    @Override
    public long getAsLong() {
        return (long)Math.floor(this.data);
    }

    @Override
    public int getAsInt() {
        return Mth.floor(this.data);
    }

    @Override
    public short getAsShort() {
        return (short)(Mth.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getAsByte() {
        return (byte)(Mth.floor(this.data) & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return (float)this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197452_) {
        return p_197452_.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

