/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public class StringTag
implements Tag {
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final TagType<StringTag> TYPE = new TagType.VariableSize<StringTag>(){

        @Override
        public StringTag load(DataInput p_129320_, NbtAccounter p_129322_) throws IOException {
            return StringTag.valueOf(1.readAccounted(p_129320_, p_129322_));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197570_, StreamTagVisitor p_197571_, NbtAccounter p_302336_) throws IOException {
            return p_197571_.visit(1.readAccounted(p_197570_, p_302336_));
        }

        private static String readAccounted(DataInput p_302398_, NbtAccounter p_302365_) throws IOException {
            p_302365_.accountBytes(36L);
            String $$2 = p_302398_.readUTF();
            p_302365_.accountBytes(2L, $$2.length());
            return $$2;
        }

        @Override
        public void skip(DataInput p_197568_, NbtAccounter p_302356_) throws IOException {
            StringTag.skipString(p_197568_);
        }

        @Override
        public String getName() {
            return "STRING";
        }

        @Override
        public String getPrettyName() {
            return "TAG_String";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private static final StringTag EMPTY = new StringTag("");
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char NOT_SET = '\u0000';
    private final String data;

    public static void skipString(DataInput p_197564_) throws IOException {
        p_197564_.skipBytes(p_197564_.readUnsignedShort());
    }

    private StringTag(String p_129293_) {
        Objects.requireNonNull(p_129293_, "Null string not allowed");
        this.data = p_129293_;
    }

    public static StringTag valueOf(String p_129298_) {
        if (p_129298_.isEmpty()) {
            return EMPTY;
        }
        return new StringTag(p_129298_);
    }

    @Override
    public void write(DataOutput p_129296_) throws IOException {
        p_129296_.writeUTF(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 36 + 2 * this.data.length();
    }

    @Override
    public byte getId() {
        return 8;
    }

    public TagType<StringTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return Tag.super.getAsString();
    }

    @Override
    public StringTag copy() {
        return this;
    }

    public boolean equals(Object p_129308_) {
        if (this == p_129308_) {
            return true;
        }
        return p_129308_ instanceof StringTag && Objects.equals(this.data, ((StringTag)p_129308_).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public String getAsString() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor p_178154_) {
        p_178154_.visitString(this);
    }

    public static String quoteAndEscape(String p_129304_) {
        StringBuilder $$1 = new StringBuilder(" ");
        int $$2 = 0;
        for (int $$3 = 0; $$3 < p_129304_.length(); ++$$3) {
            int $$4 = p_129304_.charAt($$3);
            if ($$4 == 92) {
                $$1.append('\\');
            } else if ($$4 == 34 || $$4 == 39) {
                if ($$2 == 0) {
                    int n = $$2 = $$4 == 34 ? 39 : 34;
                }
                if ($$2 == $$4) {
                    $$1.append('\\');
                }
            }
            $$1.append((char)$$4);
        }
        if ($$2 == 0) {
            $$2 = 34;
        }
        $$1.setCharAt(0, (char)$$2);
        $$1.append((char)$$2);
        return $$1.toString();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197566_) {
        return p_197566_.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

