/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> p_131861_) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> $$1 = ClientboundCommandsPacket.enumerateNodes(p_131861_);
        this.entries = ClientboundCommandsPacket.createEntries($$1);
        this.rootIndex = $$1.getInt(p_131861_);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf p_178805_) {
        this.entries = p_178805_.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = p_178805_.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf p_131886_) {
        p_131886_.writeCollection(this.entries, (p_237642_, p_237643_) -> p_237643_.write((FriendlyByteBuf)((Object)p_237642_)));
        p_131886_.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> p_237631_, BiPredicate<Entry, IntSet> p_237632_) {
        IntOpenHashSet $$2 = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)p_237631_.size()));
        while (!$$2.isEmpty()) {
            boolean $$3 = $$2.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(p_237632_, p_237631_, (IntSet)$$2, arg_0));
            if ($$3) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> p_237629_) {
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canResolve);
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> enumerateNodes(RootCommandNode<SharedSuggestionProvider> p_131863_) {
        CommandNode $$3;
        Object2IntOpenHashMap $$1 = new Object2IntOpenHashMap();
        ArrayDeque $$2 = Queues.newArrayDeque();
        $$2.add(p_131863_);
        while (($$3 = (CommandNode)$$2.poll()) != null) {
            if ($$1.containsKey((Object)$$3)) continue;
            int $$4 = $$1.size();
            $$1.put((Object)$$3, $$4);
            $$2.addAll($$3.getChildren());
            if ($$3.getRedirect() == null) continue;
            $$2.add($$3.getRedirect());
        }
        return $$1;
    }

    private static List<Entry> createEntries(Object2IntMap<CommandNode<SharedSuggestionProvider>> p_237627_) {
        ObjectArrayList $$1 = new ObjectArrayList(p_237627_.size());
        $$1.size(p_237627_.size());
        for (Object2IntMap.Entry $$2 : Object2IntMaps.fastIterable(p_237627_)) {
            $$1.set($$2.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode<SharedSuggestionProvider>)((CommandNode)$$2.getKey()), p_237627_));
        }
        return $$1;
    }

    private static Entry readNode(FriendlyByteBuf p_131888_) {
        byte $$1 = p_131888_.readByte();
        int[] $$2 = p_131888_.readVarIntArray();
        int $$3 = ($$1 & 8) != 0 ? p_131888_.readVarInt() : 0;
        NodeStub $$4 = ClientboundCommandsPacket.read(p_131888_, $$1);
        return new Entry($$4, $$1, $$3, $$2);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf p_237639_, byte p_237640_) {
        int $$2 = p_237640_ & 3;
        if ($$2 == 2) {
            String $$3 = p_237639_.readUtf();
            int $$4 = p_237639_.readVarInt();
            ArgumentTypeInfo $$5 = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId($$4);
            if ($$5 == null) {
                return null;
            }
            Object $$6 = $$5.deserializeFromNetwork(p_237639_);
            ResourceLocation $$7 = (p_237640_ & 0x10) != 0 ? p_237639_.readResourceLocation() : null;
            return new ArgumentNodeStub($$3, (ArgumentTypeInfo.Template<?>)$$6, $$7);
        }
        if ($$2 == 1) {
            String $$8 = p_237639_.readUtf();
            return new LiteralNodeStub($$8);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Entry createEntry(CommandNode<SharedSuggestionProvider> p_237622_, Object2IntMap<CommandNode<SharedSuggestionProvider>> p_237623_) {
        void $$10;
        int $$4;
        int $$2 = 0;
        if (p_237622_.getRedirect() != null) {
            $$2 |= 8;
            int $$3 = p_237623_.getInt((Object)p_237622_.getRedirect());
        } else {
            $$4 = 0;
        }
        if (p_237622_.getCommand() != null) {
            $$2 |= 4;
        }
        if (p_237622_ instanceof RootCommandNode) {
            $$2 |= 0;
            Object $$5 = null;
        } else if (p_237622_ instanceof ArgumentCommandNode) {
            ArgumentCommandNode $$6 = (ArgumentCommandNode)p_237622_;
            ArgumentNodeStub $$7 = new ArgumentNodeStub($$6);
            $$2 |= 2;
            if ($$6.getCustomSuggestions() != null) {
                $$2 |= 0x10;
            }
        } else if (p_237622_ instanceof LiteralCommandNode) {
            LiteralCommandNode $$8 = (LiteralCommandNode)p_237622_;
            LiteralNodeStub $$9 = new LiteralNodeStub($$8.getLiteral());
            $$2 |= 1;
        } else {
            throw new UnsupportedOperationException("Unknown node type " + String.valueOf(p_237622_));
        }
        int[] $$11 = p_237622_.getChildren().stream().mapToInt(arg_0 -> p_237623_.getInt(arg_0)).toArray();
        return new Entry((NodeStub)$$10, $$2, $$4, $$11);
    }

    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(ClientGamePacketListener p_131878_) {
        p_131878_.handleCommands(this);
    }

    public RootCommandNode<SharedSuggestionProvider> getRoot(CommandBuildContext p_237625_) {
        return (RootCommandNode)new NodeResolver(p_237625_, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate p_237634_, List p_237635_, IntSet p_237636_, int p_237637_) {
        return p_237634_.test((Entry)p_237635_.get(p_237637_), p_237636_);
    }

    static class Entry {
        @Nullable
        final NodeStub stub;
        final int flags;
        final int redirect;
        final int[] children;

        Entry(@Nullable NodeStub p_237668_, int p_237669_, int p_237670_, int[] p_237671_) {
            this.stub = p_237668_;
            this.flags = p_237669_;
            this.redirect = p_237670_;
            this.children = p_237671_;
        }

        public void write(FriendlyByteBuf p_237675_) {
            p_237675_.writeByte(this.flags);
            p_237675_.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                p_237675_.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(p_237675_);
            }
        }

        public boolean canBuild(IntSet p_237673_) {
            if ((this.flags & 8) != 0) {
                return !p_237673_.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet p_237677_) {
            for (int $$1 : this.children) {
                if (!p_237677_.contains($$1)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext var1);

        public void write(FriendlyByteBuf var1);
    }

    static class ArgumentNodeStub
    implements NodeStub {
        private final String id;
        private final ArgumentTypeInfo.Template<?> argumentType;
        @Nullable
        private final ResourceLocation suggestionId;

        @Nullable
        private static ResourceLocation getSuggestionId(@Nullable SuggestionProvider<SharedSuggestionProvider> p_237654_) {
            return p_237654_ != null ? SuggestionProviders.getName(p_237654_) : null;
        }

        ArgumentNodeStub(String p_237650_, ArgumentTypeInfo.Template<?> p_237651_, @Nullable ResourceLocation p_237652_) {
            this.id = p_237650_;
            this.argumentType = p_237651_;
            this.suggestionId = p_237652_;
        }

        public ArgumentNodeStub(ArgumentCommandNode<SharedSuggestionProvider, ?> p_237648_) {
            this(p_237648_.getName(), ArgumentTypeInfos.unpack(p_237648_.getType()), ArgumentNodeStub.getSuggestionId((SuggestionProvider<SharedSuggestionProvider>)p_237648_.getCustomSuggestions()));
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext p_237656_) {
            Object $$1 = this.argumentType.instantiate(p_237656_);
            RequiredArgumentBuilder $$2 = RequiredArgumentBuilder.argument((String)this.id, $$1);
            if (this.suggestionId != null) {
                $$2.suggests(SuggestionProviders.getProvider(this.suggestionId));
            }
            return $$2;
        }

        @Override
        public void write(FriendlyByteBuf p_237658_) {
            p_237658_.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(p_237658_, this.argumentType);
            if (this.suggestionId != null) {
                p_237658_.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf p_237660_, ArgumentTypeInfo.Template<A> p_237661_) {
            ArgumentNodeStub.serializeCap(p_237660_, p_237661_.type(), p_237661_);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf p_237663_, ArgumentTypeInfo<A, T> p_237664_, ArgumentTypeInfo.Template<A> p_237665_) {
            p_237663_.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(p_237664_));
            p_237664_.serializeToNetwork(p_237665_, p_237663_);
        }
    }

    static class LiteralNodeStub
    implements NodeStub {
        private final String id;

        LiteralNodeStub(String p_237680_) {
            this.id = p_237680_;
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext p_237682_) {
            return LiteralArgumentBuilder.literal((String)this.id);
        }

        @Override
        public void write(FriendlyByteBuf p_237684_) {
            p_237684_.writeUtf(this.id);
        }
    }

    static class NodeResolver {
        private final CommandBuildContext context;
        private final List<Entry> entries;
        private final List<CommandNode<SharedSuggestionProvider>> nodes;

        NodeResolver(CommandBuildContext p_237689_, List<Entry> p_237690_) {
            this.context = p_237689_;
            this.entries = p_237690_;
            ObjectArrayList $$2 = new ObjectArrayList();
            $$2.size(p_237690_.size());
            this.nodes = $$2;
        }

        public CommandNode<SharedSuggestionProvider> resolve(int p_237692_) {
            CommandNode $$5;
            CommandNode<SharedSuggestionProvider> $$1 = this.nodes.get(p_237692_);
            if ($$1 != null) {
                return $$1;
            }
            Entry $$2 = this.entries.get(p_237692_);
            if ($$2.stub == null) {
                RootCommandNode $$3 = new RootCommandNode();
            } else {
                ArgumentBuilder<SharedSuggestionProvider, ?> $$4 = $$2.stub.build(this.context);
                if (($$2.flags & 8) != 0) {
                    $$4.redirect(this.resolve($$2.redirect));
                }
                if (($$2.flags & 4) != 0) {
                    $$4.executes(p_237694_ -> 0);
                }
                $$5 = $$4.build();
            }
            this.nodes.set(p_237692_, (CommandNode<SharedSuggestionProvider>)$$5);
            for (int $$6 : $$2.children) {
                CommandNode<SharedSuggestionProvider> $$7 = this.resolve($$6);
                if ($$7 instanceof RootCommandNode) continue;
                $$5.addChild($$7);
            }
            return $$5;
        }
    }
}

