/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class SynchedEntityData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ID_VALUE = 254;
    static final ClassTreeIdRegistry ID_REGISTRY = new ClassTreeIdRegistry();
    private final SyncedDataHolder entity;
    private final DataItem<?>[] itemsById;
    private boolean isDirty;

    SynchedEntityData(SyncedDataHolder p_326156_, DataItem<?>[] p_326032_) {
        this.entity = p_326156_;
        this.itemsById = p_326032_;
    }

    public static <T> EntityDataAccessor<T> defineId(Class<? extends SyncedDataHolder> p_135354_, EntityDataSerializer<T> p_135355_) {
        int $$3;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> $$2 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!$$2.equals(p_135354_)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{p_135354_, $$2, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException $$2) {
                // empty catch block
            }
        }
        if (($$3 = ID_REGISTRY.define(p_135354_)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + $$3 + "! (Max is 254)");
        }
        return p_135355_.createAccessor($$3);
    }

    private <T> DataItem<T> getItem(EntityDataAccessor<T> p_135380_) {
        return this.itemsById[p_135380_.id()];
    }

    public <T> T get(EntityDataAccessor<T> p_135371_) {
        return this.getItem(p_135371_).getValue();
    }

    public <T> void set(EntityDataAccessor<T> p_135382_, T p_135383_) {
        this.set(p_135382_, p_135383_, false);
    }

    public <T> void set(EntityDataAccessor<T> p_276368_, T p_276363_, boolean p_276370_) {
        DataItem<T> $$3 = this.getItem(p_276368_);
        if (p_276370_ || ObjectUtils.notEqual(p_276363_, $$3.getValue())) {
            $$3.setValue(p_276363_);
            this.entity.onSyncedDataUpdated(p_276368_);
            $$3.setDirty(true);
            this.isDirty = true;
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Nullable
    public List<DataValue<?>> packDirty() {
        if (!this.isDirty) {
            return null;
        }
        this.isDirty = false;
        ArrayList $$0 = new ArrayList();
        for (DataItem<?> $$1 : this.itemsById) {
            if (!$$1.isDirty()) continue;
            $$1.setDirty(false);
            $$0.add($$1.value());
        }
        return $$0;
    }

    @Nullable
    public List<DataValue<?>> getNonDefaultValues() {
        ArrayList $$0 = null;
        for (DataItem<?> $$1 : this.itemsById) {
            if ($$1.isSetToDefault()) continue;
            if ($$0 == null) {
                $$0 = new ArrayList();
            }
            $$0.add($$1.value());
        }
        return $$0;
    }

    public void assignValues(List<DataValue<?>> p_135357_) {
        for (DataValue<?> $$1 : p_135357_) {
            DataItem<?> $$2 = this.itemsById[$$1.id];
            this.assignValue($$2, $$1);
            this.entity.onSyncedDataUpdated($$2.getAccessor());
        }
        this.entity.onSyncedDataUpdated(p_135357_);
    }

    private <T> void assignValue(DataItem<T> p_135376_, DataValue<?> p_254484_) {
        if (!Objects.equals(p_254484_.serializer(), p_135376_.accessor.serializer())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", p_135376_.accessor.id(), this.entity, p_135376_.value, p_135376_.value.getClass(), p_254484_.value, p_254484_.value.getClass()));
        }
        p_135376_.setValue(p_254484_.value);
    }

    public static class DataItem<T> {
        final EntityDataAccessor<T> accessor;
        T value;
        private final T initialValue;
        private boolean dirty;

        public DataItem(EntityDataAccessor<T> p_135394_, T p_135395_) {
            this.accessor = p_135394_;
            this.initialValue = p_135395_;
            this.value = p_135395_;
        }

        public EntityDataAccessor<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T p_135398_) {
            this.value = p_135398_;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean p_135402_) {
            this.dirty = p_135402_;
        }

        public boolean isSetToDefault() {
            return this.initialValue.equals(this.value);
        }

        public DataValue<T> value() {
            return DataValue.create(this.accessor, this.value);
        }
    }

    public record DataValue<T>(int id, EntityDataSerializer<T> serializer, T value) {
        public static <T> DataValue<T> create(EntityDataAccessor<T> p_254543_, T p_254138_) {
            EntityDataSerializer<T> $$2 = p_254543_.serializer();
            return new DataValue<T>(p_254543_.id(), $$2, $$2.copy(p_254138_));
        }

        public void write(RegistryFriendlyByteBuf p_320650_) {
            int $$1 = EntityDataSerializers.getSerializedId(this.serializer);
            if ($$1 < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.serializer));
            }
            p_320650_.writeByte(this.id);
            p_320650_.writeVarInt($$1);
            this.serializer.codec().encode(p_320650_, this.value);
        }

        public static DataValue<?> read(RegistryFriendlyByteBuf p_319816_, int p_254356_) {
            int $$2 = p_319816_.readVarInt();
            EntityDataSerializer<?> $$3 = EntityDataSerializers.getSerializer($$2);
            if ($$3 == null) {
                throw new DecoderException("Unknown serializer type " + $$2);
            }
            return DataValue.read(p_319816_, p_254356_, $$3);
        }

        private static <T> DataValue<T> read(RegistryFriendlyByteBuf p_320893_, int p_253899_, EntityDataSerializer<T> p_254222_) {
            return new DataValue<T>(p_253899_, p_254222_, p_254222_.codec().decode(p_320893_));
        }
    }

    public static class Builder {
        private final SyncedDataHolder entity;
        private final DataItem<?>[] itemsById;

        public Builder(SyncedDataHolder p_326500_) {
            this.entity = p_326500_;
            this.itemsById = new DataItem[ID_REGISTRY.getCount(p_326500_.getClass())];
        }

        public <T> Builder define(EntityDataAccessor<T> p_326262_, T p_326000_) {
            int $$2 = p_326262_.id();
            if ($$2 > this.itemsById.length) {
                throw new IllegalArgumentException("Data value id is too big with " + $$2 + "! (Max is " + this.itemsById.length + ")");
            }
            if (this.itemsById[$$2] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + $$2 + "!");
            }
            if (EntityDataSerializers.getSerializedId(p_326262_.serializer()) < 0) {
                throw new IllegalArgumentException("Unregistered serializer " + String.valueOf(p_326262_.serializer()) + " for " + $$2 + "!");
            }
            this.itemsById[p_326262_.id()] = new DataItem<T>(p_326262_, p_326000_);
            return this;
        }

        public SynchedEntityData build() {
            for (int $$0 = 0; $$0 < this.itemsById.length; ++$$0) {
                if (this.itemsById[$$0] != null) continue;
                throw new IllegalStateException("Entity " + String.valueOf(this.entity.getClass()) + " has not defined synched data value " + $$0);
            }
            return new SynchedEntityData(this.entity, this.itemsById);
        }
    }
}

