/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class Behavior<E extends LivingEntity>
implements BehaviorControl<E> {
    public static final int DEFAULT_DURATION = 60;
    protected final Map<MemoryModuleType<?>, MemoryStatus> entryCondition;
    private Status status = Status.STOPPED;
    private long endTimestamp;
    private final int minDuration;
    private final int maxDuration;

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> p_22528_) {
        this(p_22528_, 60);
    }

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> p_22530_, int p_22531_) {
        this(p_22530_, p_22531_, p_22531_);
    }

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> p_22533_, int p_22534_, int p_22535_) {
        this.minDuration = p_22534_;
        this.maxDuration = p_22535_;
        this.entryCondition = p_22533_;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public final boolean tryStart(ServerLevel p_22555_, E p_22556_, long p_22557_) {
        if (this.hasRequiredMemories(p_22556_) && this.checkExtraStartConditions(p_22555_, p_22556_)) {
            this.status = Status.RUNNING;
            int $$3 = this.minDuration + p_22555_.getRandom().nextInt(this.maxDuration + 1 - this.minDuration);
            this.endTimestamp = p_22557_ + (long)$$3;
            this.start(p_22555_, p_22556_, p_22557_);
            return true;
        }
        return false;
    }

    protected void start(ServerLevel p_22540_, E p_22541_, long p_22542_) {
    }

    @Override
    public final void tickOrStop(ServerLevel p_22559_, E p_22560_, long p_22561_) {
        if (!this.timedOut(p_22561_) && this.canStillUse(p_22559_, p_22560_, p_22561_)) {
            this.tick(p_22559_, p_22560_, p_22561_);
        } else {
            this.doStop(p_22559_, p_22560_, p_22561_);
        }
    }

    protected void tick(ServerLevel p_22551_, E p_22552_, long p_22553_) {
    }

    @Override
    public final void doStop(ServerLevel p_22563_, E p_22564_, long p_22565_) {
        this.status = Status.STOPPED;
        this.stop(p_22563_, p_22564_, p_22565_);
    }

    protected void stop(ServerLevel p_22548_, E p_22549_, long p_22550_) {
    }

    protected boolean canStillUse(ServerLevel p_22545_, E p_22546_, long p_22547_) {
        return false;
    }

    protected boolean timedOut(long p_22537_) {
        return p_22537_ > this.endTimestamp;
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, E p_22539_) {
        return true;
    }

    @Override
    public String debugString() {
        return this.getClass().getSimpleName();
    }

    protected boolean hasRequiredMemories(E p_22544_) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> $$1 : this.entryCondition.entrySet()) {
            MemoryModuleType<?> $$2 = $$1.getKey();
            MemoryStatus $$3 = $$1.getValue();
            if (((LivingEntity)p_22544_).getBrain().checkMemory($$2, $$3)) continue;
            return false;
        }
        return true;
    }

    public static enum Status {
        STOPPED,
        RUNNING;

    }
}

