/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.OctahedralGroup;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;

public enum Rotation implements StringRepresentable
{
    NONE("none", OctahedralGroup.IDENTITY),
    CLOCKWISE_90("clockwise_90", OctahedralGroup.ROT_90_Y_NEG),
    CLOCKWISE_180("180", OctahedralGroup.ROT_180_FACE_XZ),
    COUNTERCLOCKWISE_90("counterclockwise_90", OctahedralGroup.ROT_90_Y_POS);

    public static final Codec<Rotation> CODEC;
    private final String id;
    private final OctahedralGroup rotation;

    private Rotation(String p_221988_, OctahedralGroup p_221989_) {
        this.id = p_221988_;
        this.rotation = p_221989_;
    }

    public Rotation getRotated(Rotation p_55953_) {
        switch (p_55953_.ordinal()) {
            case 2: {
                switch (this.ordinal()) {
                    case 0: {
                        return CLOCKWISE_180;
                    }
                    case 1: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case 2: {
                        return NONE;
                    }
                    case 3: {
                        return CLOCKWISE_90;
                    }
                }
            }
            case 3: {
                switch (this.ordinal()) {
                    case 0: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case 1: {
                        return NONE;
                    }
                    case 2: {
                        return CLOCKWISE_90;
                    }
                    case 3: {
                        return CLOCKWISE_180;
                    }
                }
            }
            case 1: {
                switch (this.ordinal()) {
                    case 0: {
                        return CLOCKWISE_90;
                    }
                    case 1: {
                        return CLOCKWISE_180;
                    }
                    case 2: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case 3: {
                        return NONE;
                    }
                }
            }
        }
        return this;
    }

    public OctahedralGroup rotation() {
        return this.rotation;
    }

    public Direction rotate(Direction p_55955_) {
        if (p_55955_.getAxis() == Direction.Axis.Y) {
            return p_55955_;
        }
        switch (this.ordinal()) {
            case 2: {
                return p_55955_.getOpposite();
            }
            case 3: {
                return p_55955_.getCounterClockWise();
            }
            case 1: {
                return p_55955_.getClockWise();
            }
        }
        return p_55955_;
    }

    public int rotate(int p_55950_, int p_55951_) {
        switch (this.ordinal()) {
            case 2: {
                return (p_55950_ + p_55951_ / 2) % p_55951_;
            }
            case 3: {
                return (p_55950_ + p_55951_ * 3 / 4) % p_55951_;
            }
            case 1: {
                return (p_55950_ + p_55951_ / 4) % p_55951_;
            }
        }
        return p_55950_;
    }

    public static Rotation getRandom(RandomSource p_221991_) {
        return Util.getRandom(Rotation.values(), p_221991_);
    }

    public static List<Rotation> getShuffled(RandomSource p_221993_) {
        return Util.shuffledCopy(Rotation.values(), p_221993_);
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Rotation::values);
    }
}

