/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.BitSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class BelowZeroRetrogen {
    private static final BitSet EMPTY = new BitSet(0);
    private static final Codec<BitSet> BITSET_CODEC = Codec.LONG_STREAM.xmap(p_188484_ -> BitSet.valueOf(p_188484_.toArray()), p_188482_ -> LongStream.of(p_188482_.toLongArray()));
    private static final Codec<ChunkStatus> NON_EMPTY_CHUNK_STATUS = BuiltInRegistries.CHUNK_STATUS.byNameCodec().comapFlatMap(p_330147_ -> p_330147_ == ChunkStatus.EMPTY ? DataResult.error(() -> "target_status cannot be empty") : DataResult.success((Object)p_330147_), Function.identity());
    public static final Codec<BelowZeroRetrogen> CODEC = RecordCodecBuilder.create(p_338091_ -> p_338091_.group((App)NON_EMPTY_CHUNK_STATUS.fieldOf("target_status").forGetter(BelowZeroRetrogen::targetStatus), (App)BITSET_CODEC.lenientOptionalFieldOf("missing_bedrock").forGetter(p_188480_ -> p_188480_.missingBedrock.isEmpty() ? Optional.empty() : Optional.of(p_188480_.missingBedrock))).apply((Applicative)p_338091_, BelowZeroRetrogen::new));
    private static final Set<ResourceKey<Biome>> RETAINED_RETROGEN_BIOMES = Set.of(Biomes.LUSH_CAVES, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK);
    public static final LevelHeightAccessor UPGRADE_HEIGHT_ACCESSOR = new LevelHeightAccessor(){

        @Override
        public int getHeight() {
            return 64;
        }

        @Override
        public int getMinBuildHeight() {
            return -64;
        }
    };
    private final ChunkStatus targetStatus;
    private final BitSet missingBedrock;

    private BelowZeroRetrogen(ChunkStatus p_331125_, Optional<BitSet> p_188465_) {
        this.targetStatus = p_331125_;
        this.missingBedrock = p_188465_.orElse(EMPTY);
    }

    @Nullable
    public static BelowZeroRetrogen read(CompoundTag p_188486_) {
        ChunkStatus $$1 = ChunkStatus.byName(p_188486_.getString("target_status"));
        if ($$1 == ChunkStatus.EMPTY) {
            return null;
        }
        return new BelowZeroRetrogen($$1, Optional.of(BitSet.valueOf(p_188486_.getLongArray("missing_bedrock"))));
    }

    public static void replaceOldBedrock(ProtoChunk p_188475_) {
        int $$1 = 4;
        BlockPos.betweenClosed(0, 0, 0, 15, 4, 15).forEach(p_188492_ -> {
            if (p_188475_.getBlockState((BlockPos)p_188492_).is(Blocks.BEDROCK)) {
                p_188475_.setBlockState((BlockPos)p_188492_, Blocks.DEEPSLATE.defaultBlockState(), false);
            }
        });
    }

    public void applyBedrockMask(ProtoChunk p_198222_) {
        LevelHeightAccessor $$1 = p_198222_.getHeightAccessorForGeneration();
        int $$2 = $$1.getMinBuildHeight();
        int $$3 = $$1.getMaxBuildHeight() - 1;
        for (int $$4 = 0; $$4 < 16; ++$$4) {
            for (int $$5 = 0; $$5 < 16; ++$$5) {
                if (!this.hasBedrockHole($$4, $$5)) continue;
                BlockPos.betweenClosed($$4, $$2, $$5, $$4, $$3, $$5).forEach(p_198219_ -> p_198222_.setBlockState((BlockPos)p_198219_, Blocks.AIR.defaultBlockState(), false));
            }
        }
    }

    public ChunkStatus targetStatus() {
        return this.targetStatus;
    }

    public boolean hasBedrockHoles() {
        return !this.missingBedrock.isEmpty();
    }

    public boolean hasBedrockHole(int p_198215_, int p_198216_) {
        return this.missingBedrock.get((p_198216_ & 0xF) * 16 + (p_198215_ & 0xF));
    }

    public static BiomeResolver getBiomeResolver(BiomeResolver p_204532_, ChunkAccess p_204533_) {
        if (!p_204533_.isUpgrading()) {
            return p_204532_;
        }
        Predicate<ResourceKey> $$2 = RETAINED_RETROGEN_BIOMES::contains;
        return (p_204538_, p_204539_, p_204540_, p_204541_) -> {
            Holder<Biome> $$7 = p_204532_.getNoiseBiome(p_204538_, p_204539_, p_204540_, p_204541_);
            if ($$7.is($$2)) {
                return $$7;
            }
            return p_204533_.getNoiseBiome(p_204538_, 0, p_204540_);
        };
    }
}

