/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<LeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(LeaveVineDecorator::new, p_226037_ -> Float.valueOf(p_226037_.probability));
    private final float probability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.LEAVE_VINE;
    }

    public LeaveVineDecorator(float p_226031_) {
        this.probability = p_226031_;
    }

    @Override
    public void place(TreeDecorator.Context p_226039_) {
        RandomSource $$1 = p_226039_.random();
        p_226039_.leaves().forEach(p_226035_ -> {
            BlockPos $$6;
            BlockPos $$5;
            BlockPos $$4;
            BlockPos $$3;
            if ($$1.nextFloat() < this.probability && p_226039_.isAir($$3 = p_226035_.west())) {
                LeaveVineDecorator.addHangingVine($$3, VineBlock.EAST, p_226039_);
            }
            if ($$1.nextFloat() < this.probability && p_226039_.isAir($$4 = p_226035_.east())) {
                LeaveVineDecorator.addHangingVine($$4, VineBlock.WEST, p_226039_);
            }
            if ($$1.nextFloat() < this.probability && p_226039_.isAir($$5 = p_226035_.north())) {
                LeaveVineDecorator.addHangingVine($$5, VineBlock.SOUTH, p_226039_);
            }
            if ($$1.nextFloat() < this.probability && p_226039_.isAir($$6 = p_226035_.south())) {
                LeaveVineDecorator.addHangingVine($$6, VineBlock.NORTH, p_226039_);
            }
        });
    }

    private static void addHangingVine(BlockPos p_226041_, BooleanProperty p_226042_, TreeDecorator.Context p_226043_) {
        p_226043_.placeVine(p_226041_, p_226042_);
        p_226041_ = p_226041_.below();
        for (int $$3 = 4; p_226043_.isAir(p_226041_) && $$3 > 0; --$$3) {
            p_226043_.placeVine(p_226041_, p_226042_);
            p_226041_ = p_226041_.below();
        }
    }
}

