/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.hotkey;

import appeng.client.guidebook.GuidebookText;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.core.AppEngClient;
import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGuideHotkey {
    private static final KeyMapping OPEN_GUIDE_MAPPING = new KeyMapping("key.ae2.guide", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 71, "key.ae2.category");
    private static final Logger LOG = LoggerFactory.getLogger(OpenGuideHotkey.class);
    private static final int TICKS_TO_OPEN = 10;
    private static boolean newTick = true;
    private static ResourceLocation previousItemId;
    @Nullable
    private static PageAnchor guidebookPage;
    private static int ticksKeyHeld;
    private static boolean holding;

    private OpenGuideHotkey() {
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(evt -> OpenGuideHotkey.handleTooltip(evt.getItemStack(), evt.getFlags(), evt.getToolTip()));
        NeoForge.EVENT_BUS.addListener(evt -> {
            newTick = true;
        });
    }

    private static void handleTooltip(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> lines) {
        GuideScreen guideScreen;
        if (!OpenGuideHotkey.isKeyBound()) {
            holding = false;
            ticksKeyHeld = 0;
            return;
        }
        if (newTick) {
            newTick = false;
            OpenGuideHotkey.update(itemStack);
        }
        if (guidebookPage == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof GuideScreen && (guideScreen = (GuideScreen)screen).getCurrentPageId().equals((Object)guidebookPage.pageId())) {
            return;
        }
        float progress = ticksKeyHeld;
        progress = holding ? (progress += minecraft.getTimer().getRealtimeDeltaTicks()) : (progress -= minecraft.getTimer().getRealtimeDeltaTicks());
        Component component = OpenGuideHotkey.makeProgressBar(Mth.clamp((float)(progress /= 10.0f), (float)0.0f, (float)1.0f));
        if (lines.isEmpty()) {
            lines.add(component);
        } else {
            lines.add(1, component);
        }
    }

    private static Component makeProgressBar(float progress) {
        Minecraft minecraft = Minecraft.getInstance();
        MutableComponent holdW = GuidebookText.HoldToShow.text(OpenGuideHotkey.getHotkey().getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY);
        Font fontRenderer = minecraft.font;
        int charWidth = fontRenderer.width("|");
        int tipWidth = fontRenderer.width((FormattedText)holdW);
        int total = tipWidth / charWidth;
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            MutableComponent result = Component.literal((String)Strings.repeat((String)"|", (int)current)).withStyle(ChatFormatting.GRAY);
            if (progress < 1.0f) {
                result = result.append((Component)Component.literal((String)Strings.repeat((String)"|", (int)(total - current))).withStyle(ChatFormatting.DARK_GRAY));
            }
            return result;
        }
        return holdW;
    }

    private static void update(ItemStack itemStack) {
        ResourceLocation itemId = itemStack.getItemHolder().unwrapKey().map(ResourceKey::location).orElse(null);
        if (!Objects.equals(itemId, previousItemId)) {
            previousItemId = itemId;
            guidebookPage = null;
            ticksKeyHeld = 0;
            if (itemId == null) {
                return;
            }
            ItemIndex itemIndex = AppEngClient.instance().getGuide().getIndex(ItemIndex.class);
            guidebookPage = (PageAnchor)itemIndex.get(itemId);
        }
        if (holding = OpenGuideHotkey.isKeyHeld()) {
            if (ticksKeyHeld < 10 && ++ticksKeyHeld == 10) {
                if (guidebookPage != null) {
                    Screen screen = Minecraft.getInstance().screen;
                    if (screen instanceof GuideScreen) {
                        GuideScreen guideScreen = (GuideScreen)screen;
                        guideScreen.navigateTo(guidebookPage);
                    } else {
                        AppEngClient.instance().openGuideAtAnchor(guidebookPage);
                    }
                    ticksKeyHeld = 0;
                    holding = false;
                }
            } else if (ticksKeyHeld > 10) {
                ticksKeyHeld = 10;
            }
        } else {
            ticksKeyHeld = Math.max(0, ticksKeyHeld - 2);
        }
    }

    private static boolean isKeyHeld() {
        int keyCode = OpenGuideHotkey.getHotkey().getKey().getValue();
        long window = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)window, (int)keyCode);
    }

    private static boolean isKeyBound() {
        return !OPEN_GUIDE_MAPPING.isUnbound();
    }

    public static KeyMapping getHotkey() {
        return OPEN_GUIDE_MAPPING;
    }
}

