/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.export;

import java.util.List;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RenderTypeIntrospection {
    private static final Logger LOG = LoggerFactory.getLogger(RenderTypeIntrospection.class);

    private RenderTypeIntrospection() {
    }

    public static List<Sampler> getSamplers(RenderType type) {
        if (!(type instanceof RenderType.CompositeRenderType)) {
            return List.of();
        }
        RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)type;
        RenderType.CompositeState state = compositeRenderType.state();
        RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = state.textureState;
        if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
            RenderStateShard.TextureStateShard textureShard = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
            if (textureShard.texture.isPresent()) {
                ResourceLocation texture = (ResourceLocation)textureShard.texture.get();
                return List.of(new Sampler(texture, textureShard.blur, textureShard.mipmap));
            }
            LOG.warn("Render type {} is using dynamic texture", (Object)type);
        } else if (state.textureState != RenderStateShard.NO_TEXTURE) {
            LOG.warn("Cannot handle texturing of render-type {}", (Object)type);
        }
        return List.of();
    }

    public record Sampler(ResourceLocation texture, boolean blur, boolean mipmap) {
    }
}

