/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import appeng.core.network.clientbound.CompassResponsePacket;
import appeng.hooks.CompassResult;
import appeng.server.services.compass.CompassService;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public record CompassRequestPacket(long attunement, int cx, int cz, int cdy) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, CompassRequestPacket> STREAM_CODEC = StreamCodec.ofMember(CompassRequestPacket::write, CompassRequestPacket::decode);
    public static final CustomPacketPayload.Type<CompassRequestPacket> TYPE = CustomAppEngPayload.createType("compass_request");

    public CustomPacketPayload.Type<CompassRequestPacket> type() {
        return TYPE;
    }

    public static CompassRequestPacket decode(RegistryFriendlyByteBuf stream) {
        long attunement = stream.readLong();
        int cx = stream.readInt();
        int cz = stream.readInt();
        int cdy = stream.readInt();
        return new CompassRequestPacket(attunement, cx, cz, cdy);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeLong(this.attunement);
        data.writeInt(this.cx);
        data.writeInt(this.cz);
        data.writeInt(this.cdy);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        ChunkPos pos = new ChunkPos(this.cx, this.cz);
        CompassService.Result result = CompassService.getDirection(player.serverLevel(), pos, 174);
        CompassResponsePacket responsePacket = new CompassResponsePacket(this.attunement, this.cx, this.cz, this.cdy, new CompassResult(result.hasResult(), result.spin(), result.radians()));
        player.connection.send((CustomPacketPayload)responsePacket);
    }
}

