/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import org.apache.commons.lang3.mutable.MutableObject;

public class UnlitQuadHooks {
    private static final ThreadLocal<Boolean> ENABLE_UNLIT_EXTENSIONS = new ThreadLocal();

    public static void beginDeserializingModel(ResourceLocation location) {
        String namespace = location.getNamespace();
        if (namespace.equals("ae2")) {
            ENABLE_UNLIT_EXTENSIONS.set(true);
        }
    }

    public static void endDeserializingModel() {
        ENABLE_UNLIT_EXTENSIONS.set(false);
    }

    public static boolean isUnlitExtensionEnabled() {
        Boolean b = ENABLE_UNLIT_EXTENSIONS.get();
        return b != null && b != false;
    }

    public static BlockElementFace enhanceModelElementFace(BlockElementFace modelElement, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"unlit", (boolean)false)) {
            return new BlockElementFace(modelElement.cullForDirection(), modelElement.tintIndex(), modelElement.texture(), modelElement.uv(), new ExtraFaceData(-1, 15, 15, true), new MutableObject());
        }
        return modelElement;
    }
}

