/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.mdast.model;

import appeng.libs.mdast.MdAstVisitor;
import appeng.libs.mdast.model.MdAstAnyContent;
import appeng.libs.mdast.model.MdAstNode;
import appeng.libs.unist.UnistParent;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public abstract class MdAstParent<T extends MdAstAnyContent>
extends MdAstNode
implements UnistParent {
    private final List<T> children = new ArrayList<T>();

    public MdAstParent(String type) {
        super(type);
    }

    public List<T> children() {
        return this.children;
    }

    protected abstract Class<T> childClass();

    public void addChild(MdAstNode node) {
        if (!this.childClass().isInstance(node)) {
            throw new IllegalArgumentException("Cannot add a node of type " + String.valueOf(node.getClass()) + " to " + String.valueOf(this));
        }
        this.children.add((MdAstAnyContent)this.childClass().cast(node));
    }

    public void removeChild(MdAstNode node) {
        this.children.remove(this.childClass().cast(node));
    }

    @Override
    protected void writeJson(JsonWriter writer) throws IOException {
        writer.name("children");
        writer.beginArray();
        for (MdAstAnyContent child : this.children) {
            ((MdAstNode)((Object)child)).toJson(writer);
        }
        writer.endArray();
    }

    @Override
    public void toText(StringBuilder buffer) {
        for (MdAstAnyContent child : this.children) {
            if (!(child instanceof MdAstNode)) continue;
            MdAstNode childNode = (MdAstNode)((Object)child);
            childNode.toText(buffer);
        }
    }

    public void replaceChild(MdAstNode child, @Nullable MdAstNode replacement) {
        MdAstAnyContent replacementChild = replacement != null ? (MdAstAnyContent)this.childClass().cast(replacement) : null;
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != child) continue;
            if (replacement == null) {
                this.children.remove(i);
            } else {
                this.children.set(i, replacementChild);
            }
            return;
        }
        throw new IllegalStateException("Child " + String.valueOf(child) + " not found");
    }

    @Override
    protected MdAstVisitor.Result visitChildren(MdAstVisitor visitor) {
        for (MdAstAnyContent child : this.children()) {
            MdAstNode childNode;
            if (!(child instanceof MdAstNode) || (childNode = (MdAstNode)((Object)child)).visit(visitor) != MdAstVisitor.Result.STOP) continue;
            return MdAstVisitor.Result.STOP;
        }
        return MdAstVisitor.Result.CONTINUE;
    }

    @Override
    public void removeChildren(Predicate<MdAstNode> predicate, boolean recursive) {
        Iterator<T> it = this.children.iterator();
        while (it.hasNext()) {
            MdAstAnyContent child = (MdAstAnyContent)it.next();
            if (!(child instanceof MdAstNode)) continue;
            MdAstNode astNode = (MdAstNode)((Object)child);
            if (predicate.test(astNode)) {
                it.remove();
                continue;
            }
            astNode.removeChildren(predicate, recursive);
        }
    }
}

