/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.siteexport.OffScreenRenderer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public interface ResourceExporter {
    default public void referenceItem(ItemLike item) {
        this.referenceItem(new ItemStack(item));
    }

    public void referenceItem(ItemStack var1);

    public void referenceFluid(Fluid var1);

    public Path renderAndWrite(OffScreenRenderer var1, String var2, Runnable var3, Collection<TextureAtlasSprite> var4, boolean var5) throws IOException;

    public String exportTexture(ResourceLocation var1);

    public Path copyResource(ResourceLocation var1);

    public Path getPathForWriting(ResourceLocation var1);

    public Path getPageSpecificPathForWriting(String var1);

    @Nullable
    public ResourceLocation getCurrentPageId();

    public Path getOutputFolder();

    default public String getPathRelativeFromOutputFolder(Path p) {
        return "/" + this.getOutputFolder().relativize(p).toString().replace('\\', '/');
    }

    public ResourceLocation getPageSpecificResourceLocation(String var1);

    public void referenceRecipe(RecipeHolder<?> var1);
}

