/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.packetfixer.mixins;

import dev.tonimatas.packetfixer.util.Config;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.VarInt;
import net.minecraft.network.Varint21FrameDecoder;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={Varint21FrameDecoder.class})
public abstract class Varint21FrameDecoderMixin {
    @Shadow
    @Final
    @Nullable
    private BandwidthDebugMonitor monitor;
    @Unique
    private final ByteBuf packetFixer$helperBuf = Unpooled.directBuffer((int)Config.getVarInt21Size());

    @Shadow
    private static boolean copyVarint(ByteBuf byteBuf, ByteBuf byteBuf2) {
        return false;
    }

    @Overwrite
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.packetFixer$helperBuf.release();
    }

    @ModifyConstant(method={"copyVarint(Lio/netty/buffer/ByteBuf;Lio/netty/buffer/ByteBuf;)Z"}, constant={@Constant(intValue=3)})
    private static int newSize(int value) {
        return Config.getVarInt21Size();
    }

    @Overwrite
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        byteBuf.markReaderIndex();
        this.packetFixer$helperBuf.clear();
        if (!Varint21FrameDecoderMixin.copyVarint(byteBuf, this.packetFixer$helperBuf)) {
            byteBuf.resetReaderIndex();
        } else {
            int i = VarInt.read((ByteBuf)this.packetFixer$helperBuf);
            if (byteBuf.readableBytes() < i) {
                byteBuf.resetReaderIndex();
            } else {
                if (this.monitor != null) {
                    this.monitor.onReceive(i + VarInt.getByteSize((int)i));
                }
                list.add(byteBuf.readBytes(i));
            }
        }
    }
}

