/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.chalk.advancement.PlayerSleepInfo;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ConsecutiveSleepingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, PlayerSleepInfo sleepInfo) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(player, sleepInfo));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<LocationPredicate> location, MinMaxBounds.Ints count, DistancePredicate distance) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location), (App)MinMaxBounds.Ints.CODEC.fieldOf("count").forGetter(TriggerInstance::count), (App)DistancePredicate.CODEC.fieldOf("distance").forGetter(TriggerInstance::distance)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, PlayerSleepInfo sleepInfo) {
            boolean locationMatches = this.location.map(p -> p.matches(player.serverLevel(), player.getX(), player.getY(), player.getZ())).orElse(true);
            if (!locationMatches) {
                return false;
            }
            List<BlockPos> sleepPositions = sleepInfo.sleepPositions();
            if (sleepPositions.isEmpty()) {
                return false;
            }
            if (sleepPositions.size() == 1) {
                return this.count.matches(1);
            }
            BlockPos lastSleepPos = sleepPositions.getLast();
            int matchedDistanceCount = 1;
            for (int i = sleepPositions.size() - 2; i >= 0; --i) {
                BlockPos pos = sleepPositions.get(i);
                if (!this.distance.matches((double)lastSleepPos.getX(), (double)lastSleepPos.getY(), (double)lastSleepPos.getZ(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) break;
                ++matchedDistanceCount;
            }
            return this.count.matches(matchedDistanceCount);
        }
    }
}

