/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.menu.ChalkBoxMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class ChalkBoxScreen
extends AbstractContainerScreen<ChalkBoxMenu> {
    public static final ResourceLocation TEXTURE = Chalk.resource("textures/gui/container/chalk_box.png");
    private static final int GLOWING_BAR_WIDTH = 72;
    private final int maxGlowingUses = (Integer)Config.Common.CHALK_BOX_GLOWING_AMOUNT_PER_ITEM.get();
    private final Player player;

    public ChalkBoxScreen(ChalkBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.minecraft = Minecraft.getInstance();
        this.player = Minecraft.getInstance().player;
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 180;
        this.inventoryLabelY = this.imageHeight - 94;
        super.init();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        for (Slot slot : ((ChalkBoxMenu)this.getMenu()).slots) {
            if (slot.mayPickup(this.player) || slot.isActive()) continue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.blit(TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 176, 36, 20, 20);
            graphics.renderFakeItem(slot.getItem(), this.leftPos + slot.x, this.topPos + slot.y);
            graphics.fill(RenderType.guiGhostRecipeOverlay(), this.leftPos + slot.x - 1, this.topPos + slot.y - 1, this.leftPos + slot.x + 15, this.topPos + slot.y + 15, 0x40FFFFFF);
            RenderSystem.disableBlend();
        }
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(TEXTURE, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
        this.renderChalkSlots(graphics, 52, ((ChalkBoxMenu)this.getMenu()).isGlowingEnabled() ? 17 : 32);
        if (((ChalkBoxMenu)this.getMenu()).isGlowingEnabled()) {
            graphics.blit(TEXTURE, this.getGuiLeft() + 52, this.getGuiTop() + 57, 0, 217, 72, 28);
            Slot slot = (Slot)((ChalkBoxMenu)this.getMenu()).slots.get(8);
            if (slot.getItem().isEmpty()) {
                graphics.blit(TEXTURE, this.getGuiLeft() + slot.x - 1, this.getGuiTop() + slot.y - 1, 176, 18, 18, 18);
            }
            int barSize = (int)Math.ceil((float)Math.min(((ChalkBoxMenu)this.getMenu()).getGlowAmount(), this.maxGlowingUses) / (float)this.maxGlowingUses * 72.0f);
            int glowingBarFillLevel = Math.min(72, barSize);
            graphics.blit(TEXTURE, this.getGuiLeft() + 52, this.getGuiTop() + 57, 72, 217, glowingBarFillLevel, 5);
        }
    }

    protected void renderChalkSlots(GuiGraphics graphics, int x, int y) {
        graphics.blit(TEXTURE, this.getGuiLeft() + x, this.getGuiTop() + y, 0, 180, 72, 36);
        for (int slotIndex = 0; slotIndex < 8; ++slotIndex) {
            Slot slot = (Slot)((ChalkBoxMenu)this.getMenu()).slots.get(slotIndex);
            if (!slot.getItem().isEmpty()) continue;
            graphics.blit(TEXTURE, this.getGuiLeft() + slot.x - 1, this.getGuiTop() + slot.y - 1, 176, 0, 18, 18);
        }
    }
}

