/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.data.generation;

import io.github.mortuusars.chalk.data.generation.Advancements;
import io.github.mortuusars.chalk.data.generation.BlockStateGenerator;
import io.github.mortuusars.chalk.data.generation.ItemModelGenerator;
import io.github.mortuusars.chalk.data.generation.LootTables;
import io.github.mortuusars.chalk.data.generation.ModBlockTagsProvider;
import io.github.mortuusars.chalk.data.generation.ModItemTagsProvider;
import io.github.mortuusars.chalk.data.generation.Recipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="chalk", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(dataGenerator, lookupProvider, existingFileHelper);
        dataGenerator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(dataGenerator, lookupProvider, blockTagsProvider, existingFileHelper));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new Recipes(dataGenerator, lookupProvider));
        dataGenerator.addProvider(event.includeServer(), output -> new AdvancementProvider(output, lookupProvider, existingFileHelper, List.of(new Advancements())));
        dataGenerator.addProvider(event.includeServer(), output -> new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LootTables.ChestLootTables::new, LootContextParamSets.CHEST)), lookupProvider));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(dataGenerator, existingFileHelper));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(dataGenerator, existingFileHelper));
    }
}

