/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.item;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.core.IChalkDrawingTool;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.data.ChalkColors;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChalkItem
extends Item
implements IChalkDrawingTool {
    private final DyeColor color;

    public ChalkItem(DyeColor dyeColor, Item.Properties properties) {
        super(properties);
        this.color = dyeColor;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        InteractionHand hand = context.getHand();
        ItemStack itemStack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player == null || !(itemStack.getItem() instanceof ChalkItem)) {
            return InteractionResult.FAIL;
        }
        if (hand == InteractionHand.OFF_HAND && player.getMainHandItem().getItem() instanceof ChalkItem) {
            return InteractionResult.FAIL;
        }
        MarkDrawingContext drawingContext = this.createDrawingContext(player, context.getClickedPos(), context.getClickLocation(), context.getClickedFace(), hand);
        if (!drawingContext.canDraw()) {
            return InteractionResult.FAIL;
        }
        if (player.isSecondaryUseActive()) {
            drawingContext.openSymbolSelectionScreen();
            return InteractionResult.CONSUME;
        }
        if (this.drawMark(drawingContext, drawingContext.createRegularMark(ChalkColors.fromDyeColor(this.color), false))) {
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
        }
        if (drawingContext.hasExistingMark()) {
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onMarkDrawn(Player player, InteractionHand hand, BlockPos markBlockPos, BlockState markBlockState) {
        if (player.isCreative()) {
            return;
        }
        ItemStack result = ChalkItem.damageAndDestroy(player.getItemInHand(hand), player);
        if (result.isEmpty()) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
    }

    @Override
    public Mark getMark(ItemStack itemInHand, MarkDrawingContext drawingContext, MarkSymbol symbol) {
        return drawingContext.createMark(ChalkColors.fromDyeColor(this.getColor()), symbol, this.isGlowing(itemInHand));
    }

    @Override
    public int getMarkColorValue(ItemStack stack) {
        return ChalkColors.fromDyeColor(this.getColor());
    }

    @Override
    public Optional<DyeColor> getMarkColor(ItemStack stack) {
        return Optional.of(this.getColor());
    }

    @Override
    public boolean isGlowing(ItemStack stack) {
        return false;
    }

    public static ItemStack damageAndDestroy(ItemStack chalkStack, Player player) {
        if (!chalkStack.isDamageableItem()) {
            return chalkStack;
        }
        chalkStack.setDamageValue(chalkStack.getDamageValue() + 1);
        if (chalkStack.getDamageValue() >= chalkStack.getMaxDamage()) {
            Vec3 playerPos = player.position();
            player.level().playSound(player, playerPos.x, playerPos.y, playerPos.z, (SoundEvent)Chalk.SoundEvents.CHALK_BROKEN.get(), SoundSource.PLAYERS, 0.9f, 0.9f + player.level().random.nextFloat() * 0.2f);
            return ItemStack.EMPTY;
        }
        return chalkStack;
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        try {
            return (Integer)Config.Common.CHALK_DURABILITY.get();
        }
        catch (IllegalStateException e) {
            return 64;
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }
}

