/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import com.google.common.collect.Lists;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.runtime.EmiLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FillRecipeC2SPacket
implements EmiPacket {
    private final int syncId;
    private final int action;
    private final List<Integer> slots;
    private final List<Integer> crafting;
    private final int output;
    private final List<ItemStack> stacks;

    public FillRecipeC2SPacket(AbstractContainerMenu handler, int action, List<Slot> slots, List<Slot> crafting, @Nullable Slot output, List<ItemStack> stacks) {
        this.syncId = handler.containerId;
        this.action = action;
        this.slots = slots.stream().map(s -> s == null ? -1 : s.index).toList();
        this.crafting = crafting.stream().map(s -> s == null ? -1 : s.index).toList();
        this.output = output == null ? -1 : output.index;
        this.stacks = stacks;
    }

    public FillRecipeC2SPacket(RegistryFriendlyByteBuf buf) {
        this.syncId = buf.readInt();
        this.action = buf.readByte();
        this.slots = FillRecipeC2SPacket.parseCompressedSlots((FriendlyByteBuf)buf);
        this.crafting = Lists.newArrayList();
        int craftingSize = buf.readVarInt();
        for (int i = 0; i < craftingSize; ++i) {
            int s = buf.readVarInt();
            this.crafting.add(s);
        }
        this.output = buf.readBoolean() ? buf.readVarInt() : -1;
        int size = buf.readVarInt();
        this.stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.stacks.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
        }
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte(this.action);
        FillRecipeC2SPacket.writeCompressedSlots(this.slots, (FriendlyByteBuf)buf);
        buf.writeVarInt(this.crafting.size());
        for (Integer s : this.crafting) {
            buf.writeVarInt(s.intValue());
        }
        if (this.output != -1) {
            buf.writeBoolean(true);
            buf.writeVarInt(this.output);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeVarInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Player player) {
        if (this.slots == null || this.crafting == null) {
            EmiLog.error("Client requested fill but passed input and crafting slot information was invalid, aborting");
            return;
        }
        AbstractContainerMenu handler = player.containerMenu;
        if (handler == null || handler.containerId != this.syncId) {
            EmiLog.warn("Client requested fill but screen handler has changed, aborting");
            return;
        }
        ArrayList slots = Lists.newArrayList();
        ArrayList crafting = Lists.newArrayList();
        Slot output = null;
        for (int i : this.slots) {
            if (i < 0 || i >= handler.slots.size()) {
                EmiLog.error("Client requested fill but passed input slots don't exist, aborting");
                return;
            }
            slots.add((Slot)handler.slots.get(i));
        }
        for (int i : this.crafting) {
            if (i >= 0 && i < handler.slots.size()) {
                crafting.add((Slot)handler.slots.get(i));
                continue;
            }
            crafting.add(null);
        }
        if (this.output != -1 && this.output >= 0 && this.output < handler.slots.size()) {
            output = (Slot)handler.slots.get(this.output);
        }
        if (crafting.size() >= this.stacks.size()) {
            int i;
            ArrayList rubble = Lists.newArrayList();
            for (i = 0; i < crafting.size(); ++i) {
                Slot s = (Slot)crafting.get(i);
                if (s == null || !s.mayPickup(player) || s.getItem().isEmpty()) continue;
                ItemStack taken = s.getItem();
                rubble.add(taken.copy());
                s.setByPlayer(ItemStack.EMPTY);
                s.onTake(player, taken);
            }
            try {
                for (i = 0; i < this.stacks.size(); ++i) {
                    ItemStack stack = this.stacks.get(i);
                    if (stack.isEmpty()) continue;
                    int gotten = FillRecipeC2SPacket.grabMatching(player, slots, rubble, crafting, stack);
                    if (gotten != stack.getCount()) {
                        if (gotten > 0) {
                            stack.setCount(gotten);
                            player.getInventory().placeItemBackInInventory(stack);
                        }
                        return;
                    }
                    Slot s = (Slot)crafting.get(i);
                    if (s != null && s.mayPlace(stack) && stack.getCount() <= s.getMaxStackSize()) {
                        s.setByPlayer(stack);
                        continue;
                    }
                    player.getInventory().placeItemBackInInventory(stack);
                }
                if (output != null) {
                    if (this.action == 1) {
                        handler.clicked(output.getContainerSlot(), 0, ClickType.PICKUP, player);
                    } else if (this.action == 2) {
                        handler.clicked(output.getContainerSlot(), 0, ClickType.QUICK_MOVE, player);
                    }
                }
            }
            finally {
                for (ItemStack stack : rubble) {
                    player.getInventory().placeItemBackInInventory(stack);
                }
            }
        }
    }

    private static List<Integer> parseCompressedSlots(FriendlyByteBuf buf) {
        ArrayList list = Lists.newArrayList();
        int amount = buf.readVarInt();
        for (int i = 0; i < amount; ++i) {
            int low = buf.readVarInt();
            int high = buf.readVarInt();
            if (low < 0) {
                return null;
            }
            for (int j = low; j <= high; ++j) {
                list.add(j);
            }
        }
        return list;
    }

    private static void writeCompressedSlots(List<Integer> list, FriendlyByteBuf buf) {
        ArrayList postWrite = Lists.newArrayList();
        int groups = 0;
        int i = 0;
        while (i < list.size()) {
            ++groups;
            int start = i;
            int startValue = list.get(start);
            while (i < list.size() && i - start == list.get(i) - startValue) {
                ++i;
            }
            int end = i - 1;
            postWrite.add(b -> {
                b.writeVarInt(startValue);
                b.writeVarInt(((Integer)list.get(end)).intValue());
            });
        }
        buf.writeVarInt(groups);
        for (Consumer consumer : postWrite) {
            consumer.accept(buf);
        }
    }

    private static int grabMatching(Player player, List<Slot> slots, List<ItemStack> rubble, List<Slot> crafting, ItemStack stack) {
        int amount = stack.getCount();
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            ItemStack r = rubble.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)r)) continue;
            int wanted = amount - grabbed;
            if (r.getCount() <= wanted) {
                grabbed += r.getCount();
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.setCount(r.getCount() - wanted);
        }
        for (Slot s : slots) {
            ItemStack st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !s.mayPickup(player) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(st = s.getItem()))) continue;
            int wanted = amount - grabbed;
            ItemStack taken = st.copy();
            if (st.getCount() <= wanted) {
                grabbed += st.getCount();
                s.setByPlayer(ItemStack.EMPTY);
            } else {
                grabbed = amount;
                st.setCount(st.getCount() - wanted);
            }
            s.onTake(player, taken);
        }
        return grabbed;
    }

    public CustomPacketPayload.Type<FillRecipeC2SPacket> type() {
        return EmiNetwork.FILL_RECIPE;
    }
}

