/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.asm.enumextension.RuntimeEnumExtender;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.mixin.DeferredMixinConfigRegistration;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.fml.loading.modscan.BackgroundScanHandler;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class LoadingModList {
    private static LoadingModList INSTANCE;
    private final List<IModFileInfo> plugins;
    private final List<ModFileInfo> modFiles;
    private final List<ModInfo> sortedList;
    private final Map<ModInfo, List<ModInfo>> modDependencies;
    private final Map<String, ModFileInfo> fileById;
    private final List<ModLoadingIssue> modLoadingIssues;

    private LoadingModList(List<ModFile> plugins, List<ModFile> modFiles, List<ModInfo> sortedList, Map<ModInfo, List<ModInfo>> modDependencies) {
        this.plugins = plugins.stream().map(ModFile::getModFileInfo).collect(Collectors.toList());
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = sortedList.stream().map(ModInfo.class::cast).collect(Collectors.toList());
        this.modDependencies = modDependencies;
        this.fileById = this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        this.modLoadingIssues = new ArrayList<ModLoadingIssue>();
    }

    public static LoadingModList of(List<ModFile> plugins, List<ModFile> modFiles, List<ModInfo> sortedList, List<ModLoadingIssue> issues, Map<ModInfo, List<ModInfo>> modDependencies) {
        INSTANCE = new LoadingModList(plugins, modFiles, sortedList, modDependencies);
        LoadingModList.INSTANCE.modLoadingIssues.addAll(issues);
        return INSTANCE;
    }

    public static LoadingModList get() {
        return INSTANCE;
    }

    public void addMixinConfigs() {
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(file -> {
            String modId = file.getModInfos().get(0).getModId();
            file.getMixinConfigs().forEach(cfg -> DeferredMixinConfigRegistration.addMixinConfig(cfg, modId));
        });
    }

    public void addAccessTransformers() {
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(mod -> mod.getAccessTransformers().forEach(path -> FMLLoader.addAccessTransformer(path, mod)));
    }

    public void addEnumExtenders() {
        HashMap<IModInfo, Path> pathPerMod = new HashMap<IModInfo, Path>();
        this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).forEach(mod -> mod.getConfig().getConfigElement("enumExtensions").ifPresent(file -> {
            Path path = mod.getOwningFile().getFile().findResource((String)file);
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.enumextender.file_not_found", path).withAffectedMod((IModInfo)mod));
                return;
            }
            pathPerMod.put((IModInfo)mod, path);
        }));
        RuntimeEnumExtender.loadEnumPrototypes(pathPerMod);
    }

    public void addForScanning(BackgroundScanHandler backgroundScanHandler) {
        backgroundScanHandler.setLoadingModList(this);
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(backgroundScanHandler::submitForScanning);
    }

    public List<IModFileInfo> getPlugins() {
        return this.plugins;
    }

    public List<ModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public Path findResource(String className) {
        for (ModFileInfo mf : this.modFiles) {
            Path resource = mf.getFile().findResource(className);
            if (!Files.exists(resource, new LinkOption[0])) continue;
            return resource;
        }
        return null;
    }

    public Enumeration<URL> findAllURLsForResource(String resName) {
        final String resourceName = resName.startsWith("/") ? resName.substring(1) : resName;
        return new Enumeration<URL>(){
            private final Iterator<ModFileInfo> modFileIterator;
            private URL next;
            {
                this.modFileIterator = LoadingModList.this.modFiles.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                if (this.next != null) {
                    return true;
                }
                this.next = this.findNextURL();
                return this.next != null;
            }

            @Override
            public URL nextElement() {
                if (this.next == null) {
                    this.next = this.findNextURL();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                URL result = this.next;
                this.next = null;
                return result;
            }

            private URL findNextURL() {
                while (this.modFileIterator.hasNext()) {
                    ModFileInfo next = this.modFileIterator.next();
                    Path resource = next.getFile().findResource(resourceName);
                    if (!Files.exists(resource, new LinkOption[0])) continue;
                    return (URL)LambdaExceptionUtils.uncheck(() -> new URL("modjar://" + next.getMods().get(0).getModId() + "/" + resourceName));
                }
                return null;
            }
        };
    }

    public ModFileInfo getModFileById(String modid) {
        return this.fileById.get(modid);
    }

    public List<ModInfo> getMods() {
        return this.sortedList;
    }

    public List<ModInfo> getDependencies(IModInfo mod) {
        return this.modDependencies.getOrDefault(mod, List.of());
    }

    public boolean hasErrors() {
        return !this.modLoadingIssues.isEmpty() && this.modLoadingIssues.stream().anyMatch(issue -> issue.severity() == ModLoadingIssue.Severity.ERROR);
    }

    public List<ModLoadingIssue> getModLoadingIssues() {
        return this.modLoadingIssues;
    }
}

