/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.sorting;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.sorting.ISorting;
import com.chaosthedude.naturescompass.sorting.RainfallSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class DimensionSorting
implements ISorting<String> {
    private static final Minecraft mc = Minecraft.getInstance();

    @Override
    public int compare(Biome biome1, Biome biome2) {
        return this.getValue(biome1).compareTo(this.getValue(biome2));
    }

    @Override
    public String getValue(Biome biome) {
        Optional<ResourceLocation> optionalBiomeKey;
        if (DimensionSorting.mc.level != null && (optionalBiomeKey = BiomeUtils.getKeyForBiome((Level)DimensionSorting.mc.level, biome)).isPresent()) {
            return BiomeUtils.dimensionKeysToString(NaturesCompass.dimensionKeysForAllowedBiomeKeys.get((Object)optionalBiomeKey.get()));
        }
        return "";
    }

    @Override
    public ISorting<?> next() {
        return new RainfallSorting();
    }

    @Override
    public String getLocalizedName() {
        return I18n.get((String)"string.naturescompass.dimension", (Object[])new Object[0]);
    }
}

