/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.toastcontrol;

import com.google.common.base.Predicates;
import dev.shadowsoffire.toastcontrol.BetterToastComponent;
import dev.shadowsoffire.toastcontrol.ToastControl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ToastConfig {
    public static final ModConfigSpec SPEC;
    public static final ToastConfig INSTANCE;
    public final ModConfigSpec.BooleanValue advancements;
    public final ModConfigSpec.BooleanValue recipes;
    public final ModConfigSpec.BooleanValue system;
    public final ModConfigSpec.BooleanValue tutorial;
    public final ModConfigSpec.BooleanValue globalVanilla;
    public final ModConfigSpec.BooleanValue globalModded;
    public final ModConfigSpec.BooleanValue global;
    public final ModConfigSpec.ConfigValue<List<? extends String>> blockedClasses;
    public final ModConfigSpec.IntValue forceTime;
    public final ModConfigSpec.BooleanValue translucent;
    public final ModConfigSpec.BooleanValue transparent;
    public final ModConfigSpec.IntValue toastCount;
    public final ModConfigSpec.IntValue offsetX;
    public final ModConfigSpec.IntValue offsetY;
    public final ModConfigSpec.BooleanValue noSlide;
    public final ModConfigSpec.BooleanValue startLeft;
    public final ModConfigSpec.BooleanValue topDown;
    public final ModConfigSpec.BooleanValue printClasses;

    public ToastConfig(ModConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("blocked_toasts");
        this.advancements = build.comment("If advancement toasts are blocked.").define("advancements", true);
        this.recipes = build.comment("If recipe toasts are blocked.").define("recipes", true);
        this.system = build.comment("If system toasts are blocked.").define("system", false);
        this.tutorial = build.comment("If tutorial toasts are blocked.").define("tutorial", true);
        this.globalVanilla = build.comment("If all vanilla toasts are blocked.").define("global_vanilla", false);
        this.globalModded = build.comment("If all non-vanilla toasts are blocked.").define("global_modded", false);
        this.global = build.comment("If all toasts are blocked.").define("global", false);
        this.blockedClasses = build.comment("Toast Classes that are blocked from being shown.").defineList("blocked_classes", new ArrayList(), (Predicate)Predicates.alwaysTrue());
        build.pop().push("visual_options");
        this.forceTime = build.comment("How long a toast must be on the screen for, in ticks.  Use 0 to use the default time.").defineInRange("force_time", 0, 0, 4000);
        this.translucent = build.comment("If toasts are translucent.").define("translucent", true);
        this.transparent = build.comment("If toasts are transparent.  Overrides translucency.").define("transparent", false);
        this.toastCount = build.comment("How many toasts will be displayed on screen at once.").defineInRange("toast_count", 3, 1, 7);
        this.offsetX = build.comment("The X offset for toasts to be drawn at.").defineInRange("x_offset", 0, -8192, 8192);
        this.offsetY = build.comment("The Y offset for toasts to be drawn at.").defineInRange("y_offset", 0, -8192, 8192);
        this.noSlide = build.comment("If toasts automatically pop into the screen without animations.").define("no_slide", false);
        this.startLeft = build.comment("If toasts show on the left of the screen.").define("start_left", false);
        this.topDown = build.comment("If toasts will come in from the top of the screen, rather than the side.").define("top_down", false);
        build.pop().push("debug");
        this.printClasses = build.comment("If toast classes are printed when they are shown.").define("print_classes", false);
        build.pop().pop();
    }

    public static boolean isTextureTransparent() {
        return ToastConfig.INSTANCE.transparent.getAsBoolean();
    }

    public static boolean isTextureTranslucent() {
        return ToastConfig.INSTANCE.translucent.getAsBoolean();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Reloading e) {
        if ("toastcontrol".equals(e.getConfig().getModId())) {
            Minecraft.getInstance().submit(() -> {
                Minecraft.getInstance().toast = new BetterToastComponent();
                ToastControl.handleToastReloc();
                ToastControl.handleBlockedClasses();
                ToastControl.LOGGER.info("Toast control config reloaded.");
            });
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ToastConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (ToastConfig)specPair.getLeft();
    }
}

