/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.utils.files.GlobalStorage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.json.typeadapter.KeyFramesAdapter;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.GeometryTree;
import software.bernie.geckolib.model.GeoModel;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetic;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticTexture;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.DownloadedAsset;

public class CosmeticModel
extends GeoModel<Cosmetic> {
    private static final Path CACHE = GlobalStorage.getCacheDirectory((String)"creeperoverhaul").resolve("cosmetics").resolve("models");
    private final BakedGeoModel model;
    private final CosmeticTexture texture;
    private boolean loaded = false;

    private CosmeticModel(JsonElement model, CosmeticTexture texture) {
        this.model = BakedModelFactory.getForNamespace((String)"creeperoverhaul").constructGeoModel(GeometryTree.fromModel((Model)((Model)KeyFramesAdapter.GEO_GSON.fromJson(model, Model.class))));
        this.texture = texture;
    }

    public static void create(String url, CosmeticTexture texture, Consumer<CosmeticModel> factory) throws FileNotFoundException {
        File file = CACHE.resolve(DownloadedAsset.getUrlHash(url)).toFile();
        if (file.exists() && file.isFile()) {
            JsonObject json = (JsonObject)Constants.GSON.fromJson(new JsonReader((Reader)new FileReader(file)), JsonObject.class);
            factory.accept(new CosmeticModel((JsonElement)json, texture));
        } else {
            DownloadedAsset.runDownload(url, file, stream -> {
                JsonObject json = (JsonObject)Constants.GSON.fromJson(new JsonReader((Reader)new InputStreamReader((InputStream)stream)), JsonObject.class);
                factory.accept(new CosmeticModel((JsonElement)json, texture));
            });
        }
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        if (!this.loaded) {
            this.getAnimationProcessor().setActiveModel(this.model);
            this.loaded = true;
        }
        return this.model;
    }

    public ResourceLocation getModelResource(Cosmetic animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"creeperoverhaul", (String)"geo/cosmetic.geo.json");
    }

    public ResourceLocation getTextureResource(Cosmetic animatable) {
        return this.texture.getResourceLocation();
    }

    public ResourceLocation getAnimationResource(Cosmetic animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"creeperoverhaul", (String)"animations/empty.animation.json");
    }
}

