/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.util.UndashedUuid;
import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetic;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticAnchor;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticModel;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticTexture;

public class Cosmetics {
    private static final String URL = "https://creeper-overhaul.thatgravyboat.tech/cosmetics";
    private static final Map<String, Cosmetic> COSMETICS = new HashMap<String, Cosmetic>();
    private static final Map<UUID, String> USERS = new HashMap<UUID, String>();
    private static final Set<UUID> DISABLED = new HashSet<UUID>();

    private static void addCosmetic(String id, Cosmetic cosmetic) {
        COSMETICS.put(id, cosmetic);
    }

    private static void addUser(String uuid, String cosmetic) {
        try {
            Cosmetics.getUUID(uuid).ifPresent(uid -> USERS.put((UUID)uid, cosmetic));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Optional<UUID> getUUID(String uuid) throws IllegalArgumentException {
        if (uuid.length() == 36 && uuid.contains("-")) {
            return Optional.of(UndashedUuid.fromStringLenient((String)uuid));
        }
        if (uuid.length() == 32) {
            return Optional.of(UUID.fromString(uuid));
        }
        return Optional.empty();
    }

    public static void init() {
        JsonObject json = WebUtils.getJson((String)URL, (boolean)true);
        if (json == null) {
            return;
        }
        JsonObject cosmetics = json.getAsJsonObject("cosmetics");
        JsonObject users = json.getAsJsonObject("users");
        cosmetics.entrySet().forEach(entry -> {
            try {
                String id = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                CosmeticTexture texture = new CosmeticTexture(data.get("texture").getAsString());
                CosmeticModel.create(data.get("model").getAsString(), texture, model -> Cosmetics.addCosmetic(id, new Cosmetic(texture, (CosmeticModel)((Object)((Object)model)), CosmeticAnchor.valueOf(data.get("anchor").getAsString()))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        users.entrySet().forEach(entry -> Cosmetics.addUser((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
    }

    public static Cosmetic getCosmetic(UUID player) {
        if (DISABLED.contains(player)) {
            return null;
        }
        String cosmetic = USERS.get(player);
        if (cosmetic == null) {
            return COSMETICS.get("default");
        }
        return COSMETICS.get(cosmetic);
    }

    public static void setCosmeticShown(UUID player, boolean show) {
        if (show) {
            DISABLED.remove(player);
        } else {
            DISABLED.add(player);
        }
    }
}

