/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.custom;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.creeperoverhaul.api.PluginRegistry;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.WaterCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSounds;

public class PufferfishCreeper
extends WaterCreeper {
    private static final TargetingConditions TARGETS = TargetingConditions.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight().selector(entity -> !entity.getType().is(EntityTypeTags.NOT_SCARY_FOR_PUFFERFISH) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity) && entity.isAlive());
    private static final List<EntityDimensions> DIMENSIONS = List.of(EntityDimensions.scalable((float)0.6875f, (float)1.125f), EntityDimensions.scalable((float)0.625f, (float)0.9375f), EntityDimensions.scalable((float)1.0f, (float)1.375f));
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(PufferfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> PUFF_STATE = SynchedEntityData.defineId(PufferfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private int inflateCounter;
    private int deflateTimer;

    public PufferfishCreeper(EntityType<? extends PufferfishCreeper> entityType, Level level, CreeperType type) {
        super(entityType, level, type);
    }

    public static EntityType.EntityFactory<PufferfishCreeper> ofPufferfish(CreeperType type) {
        return (entityType, level) -> new PufferfishCreeper((EntityType<? extends PufferfishCreeper>)entityType, level, type);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data) {
        this.setVariant(level.getRandom().nextBoolean() ? Variant.TEAL : Variant.BROWN);
        return super.finalizeSpawn(level, difficulty, type, data);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PuffGoal(this));
    }

    @Override
    protected void registerAttackGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> PluginRegistry.getInstance().canAttack(this, (LivingEntity)entity)));
        this.goalSelector.addGoal(4, (Goal)new CreeperMeleeAttackGoal(this, 3.0, false));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(PUFF_STATE, (Object)0);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (VARIANT.equals(accessor)) {
            this.refreshDimensions();
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(VARIANT, (Object)(tag.getByte("Variant") == 0 ? (byte)0 : 1));
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("Variant", ((Byte)this.entityData.get(VARIANT)).byteValue());
    }

    public byte getPuffState() {
        return (Byte)this.entityData.get(PUFF_STATE);
    }

    public void setPuffState(int puffState) {
        this.entityData.set(PUFF_STATE, (Object)((byte)puffState));
    }

    public Variant getVariant() {
        return Variant.byId((Byte)this.entityData.get(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.entityData.set(VARIANT, (Object)((byte)variant.ordinal()));
    }

    public int getPuffId() {
        return switch (this.getPuffState()) {
            case 0 -> 1;
            case 1 -> 2;
            default -> 3;
        };
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.playSound(ModSounds.OCEAN_INFLATE.get(), this.getSoundVolume(), this.getVoicePitch());
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.playSound(ModSounds.OCEAN_INFLATE.get(), this.getSoundVolume(), this.getVoicePitch());
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.playSound(ModSounds.OCEAN_DEFLATE.get(), this.getSoundVolume(), this.getVoicePitch());
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.playSound(ModSounds.OCEAN_DEFLATE.get(), this.getSoundVolume(), this.getVoicePitch());
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.tick();
    }

    @Override
    public boolean doHurtTarget(@NotNull Entity entity) {
        byte state = this.getPuffState();
        if (entity.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (6.0f + (float)state) * (this.isPowered() ? 2.0f : 1.0f))) {
            this.playSound(SoundEvents.PUFFER_FISH_STING, 1.0f, 1.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 60 * state, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canSwell() {
        return false;
    }

    private boolean canTouch(LivingEntity entity) {
        return TARGETS.test((LivingEntity)this, entity);
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        return DIMENSIONS.get(this.getPuffId() - 1);
    }

    public static enum Variant {
        TEAL,
        BROWN;


        public static Variant byId(byte id) {
            return id == 0 ? TEAL : BROWN;
        }
    }

    public static class PuffGoal
    extends Goal {
        private final PufferfishCreeper creeper;

        public PuffGoal(PufferfishCreeper creeper) {
            this.creeper = creeper;
        }

        public boolean canUse() {
            List list = this.creeper.level().getEntitiesOfClass(Player.class, this.creeper.getBoundingBox().inflate(6.0), this.creeper::canTouch);
            return !list.isEmpty();
        }

        public void start() {
            this.creeper.inflateCounter = 1;
            this.creeper.deflateTimer = 0;
        }

        public void stop() {
            this.creeper.inflateCounter = 0;
        }
    }
}

